/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.base.io.IRandomAccessFile;

public class DataTypeUtil {
    public static final String TIFF_FILE = "tif";
    public static final String PNG_FILE = "png";
    public static final String JPEG_FILE = "jpg";
    public static final String GIF_FILE = "gif";
    private static final MagicNumbersManager MAGIC_NUMBERS_MANAGER = new MagicNumbersManager(new MagicNumber("gif", "474946383961", "474946383761"), new MagicNumber("jpg", "ffd8ff"), new MagicNumber("png", "89504e470d0a1a0a"), new MagicNumber("tif", "49492a00", "4d4d002a"));

    public static String tryToFigureOutFileTypeOf(IRandomAccessFile handle) {
        if (!handle.markSupported()) {
            throw new IllegalArgumentException("Input stream does not support marking. Wrap input stream with a BufferedInputStream to solve the problem.");
        }
        int maxLength = MAGIC_NUMBERS_MANAGER.getMaxLength();
        handle.mark(maxLength);
        byte[] initialBytes = new byte[maxLength];
        handle.read(initialBytes);
        handle.reset();
        return MAGIC_NUMBERS_MANAGER.tryToFigureOutFileTypeOf(initialBytes);
    }

    public static boolean isTiff(String fileTypeOrNull) {
        return TIFF_FILE.equals(fileTypeOrNull);
    }

    public static boolean isJpeg(String fileTypeOrNull) {
        return JPEG_FILE.equals(fileTypeOrNull);
    }

    public static boolean isPng(String fileTypeOrNull) {
        return PNG_FILE.equals(fileTypeOrNull);
    }

    public static boolean isGif(String fileTypeOrNull) {
        return GIF_FILE.equals(fileTypeOrNull);
    }

    private DataTypeUtil() {
    }

    private static final class MagicNumber {
        private final String fileType;
        private final String[] magicHexNumbers;
        private final int maxLength;

        MagicNumber(String fileType, String ... magicHexNumbers) {
            this.fileType = fileType;
            this.magicHexNumbers = magicHexNumbers;
            int length = 0;
            String[] stringArray = magicHexNumbers;
            int n = magicHexNumbers.length;
            int n2 = 0;
            while (n2 < n) {
                String magicNumber = stringArray[n2];
                length = Math.max(length, magicNumber.length());
                ++n2;
            }
            this.maxLength = length / 2;
        }

        public String getFileType() {
            return this.fileType;
        }

        int getMaxLength() {
            return this.maxLength;
        }

        public boolean matches(byte[] bytes) {
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < this.maxLength) {
                byte b = bytes[i];
                builder.append(Integer.toHexString(b >> 4 & 0xF));
                builder.append(Integer.toHexString(b & 0xF));
                ++i;
            }
            String initialBytes = builder.toString().toLowerCase();
            String[] stringArray = this.magicHexNumbers;
            int n = this.magicHexNumbers.length;
            int n2 = 0;
            while (n2 < n) {
                String magicNumber = stringArray[n2];
                if (initialBytes.startsWith(magicNumber)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    private static final class MagicNumbersManager {
        private final MagicNumber[] magicNumbers;

        MagicNumbersManager(MagicNumber ... magicNumbers) {
            this.magicNumbers = magicNumbers;
        }

        int getMaxLength() {
            int max = 0;
            MagicNumber[] magicNumberArray = this.magicNumbers;
            int n = this.magicNumbers.length;
            int n2 = 0;
            while (n2 < n) {
                MagicNumber magicNumber = magicNumberArray[n2];
                max = Math.max(max, magicNumber.getMaxLength());
                ++n2;
            }
            return max;
        }

        String tryToFigureOutFileTypeOf(byte[] initialBytes) {
            MagicNumber[] magicNumberArray = this.magicNumbers;
            int n = this.magicNumbers.length;
            int n2 = 0;
            while (n2 < n) {
                MagicNumber magicNumber = magicNumberArray[n2];
                if (magicNumber.matches(initialBytes)) {
                    return magicNumber.getFileType();
                }
                ++n2;
            }
            return null;
        }
    }
}

