/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;

public final class DateTimeUtils {
    public static final String getTimeZone(Date date) {
        assert (date != null) : "Unspecified date.";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        StringBuffer zoneString = new StringBuffer();
        int value = calendar.get(15) + calendar.get(16);
        if (value < 0) {
            zoneString.append('-');
            value = -value;
        } else {
            zoneString.append('+');
        }
        int num = value / 3600000;
        zoneString.append(DateTimeUtils.prependZeroIfNeeded(num));
        zoneString.append(":");
        num = value % 3600000 / 60000;
        zoneString.append(DateTimeUtils.prependZeroIfNeeded(num));
        return "GMT" + zoneString.toString();
    }

    private static final String prependZeroIfNeeded(int num) {
        return num < 10 ? "0" + num : "" + num;
    }

    public static String renderDuration(long durationInMillisecondsOrNeg) {
        if (durationInMillisecondsOrNeg < 0L) {
            return "?";
        }
        if (durationInMillisecondsOrNeg < 1000L) {
            return DateTimeUtils.render(1L, "sec");
        }
        long durationInSeconds = (durationInMillisecondsOrNeg + 500L) / 1000L;
        if (durationInSeconds < 100L) {
            return DateTimeUtils.render(durationInSeconds, "sec");
        }
        long durationInMinutes = (durationInSeconds + 30L) / 60L;
        if (durationInMinutes < 60L) {
            return DateTimeUtils.render(durationInMinutes, "min");
        }
        long minutes = durationInMinutes % 60L;
        long hours = durationInMinutes / 60L;
        return String.valueOf(DateTimeUtils.render(hours, "h")) + " " + DateTimeUtils.render(minutes, "min");
    }

    private static String render(long value, String unit) {
        return String.valueOf(value) + unit;
    }

    public static Date extendUntilEndOfDay(Date date) {
        return DateUtils.addMilliseconds((Date)DateUtils.addDays((Date)DateUtils.truncate((Date)date, (int)5), (int)1), (int)-1);
    }
}

