/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalContentUtils {
    static final Comparator<IHierarchicalContentNode> DEFAULT_NODE_COMPARATOR = new Comparator<IHierarchicalContentNode>(){

        @Override
        public int compare(IHierarchicalContentNode node1, IHierarchicalContentNode node2) {
            return this.createSortableName(node1).compareTo(this.createSortableName(node2));
        }

        private String createSortableName(IHierarchicalContentNode node) {
            return String.valueOf(node.isDirectory() ? "D" : "F") + node.getName().toUpperCase();
        }
    };

    public static void sortNodes(List<IHierarchicalContentNode> nodes) {
        Collections.sort(nodes, DEFAULT_NODE_COMPARATOR);
    }

    public static InputStream getInputStreamAutoClosingContent(IHierarchicalContentNode node, IHierarchicalContent content) throws IOExceptionUnchecked {
        return new HierarchicalContentClosingInputStream(node.getInputStream(), content);
    }

    static class HierarchicalContentClosingInputStream
    extends FilterInputStream {
        private final IHierarchicalContent hierarchicalContent;

        public HierarchicalContentClosingInputStream(InputStream target, IHierarchicalContent hierarchicalContent) {
            super(target);
            this.hierarchicalContent = hierarchicalContent;
        }

        public void close() throws IOException {
            this.hierarchicalContent.close();
            super.close();
        }
    }
}

