/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.utilities.ExtendedProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public class PropertyParametersUtil {
    public static final String ITEMS_DELIMITER = ",";

    public static SectionProperties[] extractSectionProperties(Properties properties, String sectionNamesPropertyName, boolean attachGeneralProperties) {
        String[] names = PropertyParametersUtil.tryParseItemisedProperty(properties, sectionNamesPropertyName);
        if (names == null) {
            return new SectionProperties[0];
        }
        SectionProperties[] sectionProperties = PropertyParametersUtil.extractSectionProperties(names, properties);
        if (attachGeneralProperties) {
            PropertyParametersUtil.attachGeneralProperties(properties, names, sectionProperties);
        }
        return sectionProperties;
    }

    public static SectionProperties extractSingleSectionProperties(Properties properties, String sectionName, boolean attachGeneralProperties) {
        String[] names = new String[]{sectionName};
        SectionProperties[] sectionProperties = PropertyParametersUtil.extractSectionProperties(names, properties);
        if (attachGeneralProperties) {
            PropertyParametersUtil.attachGeneralProperties(properties, names, sectionProperties);
        }
        return sectionProperties[0];
    }

    private static String[] tryParseItemisedProperty(Properties properties, String itemsListPropertyName) {
        String namesText = properties.getProperty(itemsListPropertyName);
        if (namesText == null) {
            return null;
        }
        return PropertyParametersUtil.parseItemisedProperty(namesText, itemsListPropertyName);
    }

    public static String[] parseItemisedProperty(String itemsList, String itemsListPropertyName) {
        if (itemsList.trim().length() == 0) {
            return new String[0];
        }
        String[] names = itemsList.split(ITEMS_DELIMITER);
        names = PropertyParametersUtil.trim(names);
        PropertyParametersUtil.validateUniqueNonemptyNames(names, itemsListPropertyName);
        return names;
    }

    private static String[] trim(String[] names) {
        String[] trimmedNames = new String[names.length];
        int i = 0;
        while (i < trimmedNames.length) {
            trimmedNames[i] = names[i].trim();
            ++i;
        }
        return trimmedNames;
    }

    private static void attachGeneralProperties(Properties properties, String[] names, SectionProperties[] sectionProperties) {
        ExtendedProperties generalProperties = PropertyParametersUtil.extractGeneralProperties(names, properties);
        SectionProperties[] sectionPropertiesArray = sectionProperties;
        int n = sectionProperties.length;
        int n2 = 0;
        while (n2 < n) {
            SectionProperties section = sectionPropertiesArray[n2];
            section.getProperties().putAll((Map<?, ?>)generalProperties);
            ++n2;
        }
    }

    private static SectionProperties[] extractSectionProperties(String[] sectionNames, Properties properties) {
        SectionProperties[] sections = new SectionProperties[sectionNames.length];
        int i = 0;
        while (i < sectionNames.length) {
            String name = sectionNames[i].trim();
            ExtendedProperties sectionProperties = ExtendedProperties.getSubset(properties, PropertyParametersUtil.getPropertyPrefix(name), true);
            sections[i] = new SectionProperties(name, sectionProperties);
            ++i;
        }
        return sections;
    }

    private static ExtendedProperties extractGeneralProperties(String[] names, Properties properties) {
        ExtendedProperties generalProperties = ExtendedProperties.createWith(properties);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            generalProperties.removeSubset(PropertyParametersUtil.getPropertyPrefix(name));
            ++n2;
        }
        return generalProperties;
    }

    private static String getPropertyPrefix(String name) {
        return String.valueOf(name) + ".";
    }

    private static void validateUniqueNonemptyNames(String[] names, String propertyName) {
        HashSet<String> processed = new HashSet<String>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (processed.contains(name)) {
                throw ConfigurationFailureException.fromTemplate("Duplicated name '%s' in '%s' property.", name, propertyName);
            }
            if (name.length() == 0) {
                throw ConfigurationFailureException.fromTemplate("Empty name in '%s' property.", propertyName);
            }
            processed.add(name);
            ++n2;
        }
    }

    public static class SectionProperties {
        private final String key;
        private final Properties sectionProperties;

        public SectionProperties(String key, Properties sectionProperties) {
            this.key = key;
            this.sectionProperties = sectionProperties;
        }

        public String getKey() {
            return this.key;
        }

        public Properties getProperties() {
            return this.sectionProperties;
        }
    }
}

