/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.collections.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyUtils {
    static final String EMPTY_STRING_FORMAT = "Property '%s' is not specified.";
    static final String NON_BOOLEAN_VALUE_FORMAT = "Invalid boolean '%s'. Default value '%s' will be used.";
    static final String NON_CHAR_VALUE_FORMAT = "Invalid character '%s' (incorrect length). Default value '%s' will be used.";
    static final String NON_INT_VALUE_FORMAT = "Invalid integer '%s'. Default value '%s' will be used.";
    static final String NOT_POSITIVE_INT_VALUE_FORMAT = "Invalid positive integer '%s'. Default value '%s' will be used.";
    static final String NON_LONG_VALUE_FORMAT = "Invalid long '%s'. Default value '%s' will be used.";
    static final String NON_DOUBLE_VALUE_FORMAT = "Invalid double '%s'. Default value '%s' will be used.";
    static final String NOT_POSITIVE_LONG_VALUE_FORMAT = "Invalid positive long '%s'. Default value '%s' will be used.";
    static final String NOT_FOUND_PROPERTY_FORMAT = "Given key '%s' not found in properties '%s'";
    private static final String LIST_SEPARATOR = ",";

    private PropertyUtils() {
    }

    private static void assertParameters(Properties properties, String propertyKey) {
        assert (properties != null) : "Given properties can not be null.";
        assert (propertyKey != null) : "Given property key can not be null.";
    }

    public static final String getProperty(Properties properties, String propertyKey) {
        PropertyUtils.assertParameters(properties, propertyKey);
        String property = properties.getProperty(propertyKey);
        return property == null ? null : property.trim();
    }

    public static final String getProperty(Properties properties, String propertyKey, String defaultValue) {
        String property = PropertyUtils.getProperty(properties, propertyKey);
        return property == null ? defaultValue : property;
    }

    public static final String getMandatoryProperty(Properties properties, String propertyKey) throws ConfigurationFailureException {
        PropertyUtils.assertParameters(properties, propertyKey);
        String property = PropertyUtils.getProperty(properties, propertyKey);
        if (property == null) {
            throw PropertyUtils.createPropertyNotFoundException(properties, propertyKey);
        }
        if (property.length() == 0) {
            throw ConfigurationFailureException.fromTemplate(EMPTY_STRING_FORMAT, propertyKey);
        }
        return property;
    }

    private static ConfigurationFailureException createPropertyNotFoundException(Properties properties, String propertyKey) {
        return ConfigurationFailureException.fromTemplate(NOT_FOUND_PROPERTY_FORMAT, propertyKey, CollectionUtils.abbreviate(Collections.list(properties.propertyNames()), 10));
    }

    public static final List<String> getMandatoryList(Properties properties, String propertyKey) {
        List<String> list = PropertyUtils.tryGetList(properties, propertyKey);
        if (list == null) {
            throw PropertyUtils.createPropertyNotFoundException(properties, propertyKey);
        }
        if (list.size() == 0) {
            throw ConfigurationFailureException.fromTemplate(EMPTY_STRING_FORMAT, propertyKey);
        }
        return list;
    }

    public static final List<String> tryGetList(Properties properties, String propertyKey) {
        String itemsList = PropertyUtils.getProperty(properties, propertyKey);
        if (itemsList == null) {
            return null;
        }
        String[] items = itemsList.split(LIST_SEPARATOR);
        int i = 0;
        while (i < items.length) {
            items[i] = items[i].trim().toUpperCase();
            ++i;
        }
        return Arrays.asList(items);
    }

    public static final long getLong(Properties properties, String propertyKey, long defaultValue, ISimpleLogger loggerOrNull) {
        PropertyUtils.assertParameters(properties, propertyKey);
        String longOrNull = PropertyUtils.getProperty(properties, propertyKey);
        if (longOrNull == null) {
            return defaultValue;
        }
        if (!NumberUtils.isNumber((String)longOrNull)) {
            if (loggerOrNull != null) {
                loggerOrNull.log(LogLevel.INFO, String.format(NON_LONG_VALUE_FORMAT, longOrNull, defaultValue));
            }
            return defaultValue;
        }
        return NumberUtils.createNumber((String)longOrNull).longValue();
    }

    public static final long getLong(Properties properties, String propertyKey, long defaultValue) {
        return PropertyUtils.getLong(properties, propertyKey, defaultValue, null);
    }

    public static final long getPosLong(Properties properties, String propertyKey, long defaultValue, ISimpleLogger loggerOrNull) {
        PropertyUtils.assertParameters(properties, propertyKey);
        assert (defaultValue > -1L) : "Negative default value (< 0).";
        String longOrNull = PropertyUtils.getProperty(properties, propertyKey);
        if (longOrNull == null) {
            return defaultValue;
        }
        if (!NumberUtils.isDigits((String)longOrNull)) {
            if (loggerOrNull != null) {
                loggerOrNull.log(LogLevel.INFO, String.format(NON_LONG_VALUE_FORMAT, longOrNull, defaultValue));
            }
            return defaultValue;
        }
        return Long.parseLong(longOrNull);
    }

    public static final long getPosLong(Properties properties, String propertyKey, long defaultValue) {
        return PropertyUtils.getPosLong(properties, propertyKey, defaultValue, null);
    }

    public static final int getInt(Properties properties, String propertyKey, int defaultValue, ISimpleLogger loggerOrNull) {
        PropertyUtils.assertParameters(properties, propertyKey);
        String intOrNull = PropertyUtils.getProperty(properties, propertyKey);
        if (intOrNull == null) {
            return defaultValue;
        }
        if (!NumberUtils.isNumber((String)intOrNull)) {
            if (loggerOrNull != null) {
                loggerOrNull.log(LogLevel.INFO, String.format(NON_INT_VALUE_FORMAT, intOrNull, defaultValue));
            }
            return defaultValue;
        }
        return NumberUtils.createNumber((String)intOrNull).intValue();
    }

    public static final int getInt(Properties properties, String propertyKey, int defaultValue) {
        return PropertyUtils.getInt(properties, propertyKey, defaultValue, null);
    }

    public static final int getPosInt(Properties properties, String propertyKey, int defaultValue, ISimpleLogger loggerOrNull) {
        PropertyUtils.assertParameters(properties, propertyKey);
        assert (defaultValue > -1) : "Negative default value (< 0).";
        String intOrNull = PropertyUtils.getProperty(properties, propertyKey);
        if (intOrNull == null) {
            return defaultValue;
        }
        if (!NumberUtils.isDigits((String)intOrNull)) {
            if (loggerOrNull != null) {
                loggerOrNull.log(LogLevel.INFO, String.format(NON_INT_VALUE_FORMAT, intOrNull, defaultValue));
            }
            return defaultValue;
        }
        return Integer.parseInt(intOrNull);
    }

    public static final int getPosInt(Properties properties, String propertyKey, int defaultValue) {
        return PropertyUtils.getPosInt(properties, propertyKey, defaultValue, null);
    }

    public static final double getDouble(Properties properties, String propertyKey, double defaultValue, ISimpleLogger loggerOrNull) {
        PropertyUtils.assertParameters(properties, propertyKey);
        String doubleOrNull = PropertyUtils.getProperty(properties, propertyKey);
        if (doubleOrNull == null) {
            return defaultValue;
        }
        if (!NumberUtils.isNumber((String)doubleOrNull)) {
            if (loggerOrNull != null) {
                loggerOrNull.log(LogLevel.INFO, String.format(NON_DOUBLE_VALUE_FORMAT, doubleOrNull, defaultValue));
            }
            return defaultValue;
        }
        return Double.parseDouble(doubleOrNull);
    }

    public static final double getDouble(Properties properties, String propertyKey, double defaultValue) {
        return PropertyUtils.getDouble(properties, propertyKey, defaultValue, null);
    }

    public static final boolean getBoolean(Properties properties, String propertyKey, boolean defaultValue, ISimpleLogger loggerOrNull) {
        PropertyUtils.assertParameters(properties, propertyKey);
        String booleanOrNull = PropertyUtils.getProperty(properties, propertyKey);
        if (booleanOrNull == null) {
            return defaultValue;
        }
        Boolean bool = Boolean.getBoolean(booleanOrNull);
        if (bool == null) {
            if (loggerOrNull != null) {
                loggerOrNull.log(LogLevel.INFO, String.format(NON_BOOLEAN_VALUE_FORMAT, booleanOrNull, defaultValue));
            }
            return defaultValue;
        }
        return Boolean.toBoolean(bool);
    }

    public static final char getChar(Properties properties, String propertyKey, char defaultValue) {
        return PropertyUtils.getChar(properties, propertyKey, defaultValue, null);
    }

    public static final char getChar(Properties properties, String propertyKey, char defaultValue, ISimpleLogger loggerOrNull) {
        PropertyUtils.assertParameters(properties, propertyKey);
        String charOrNull = PropertyUtils.getProperty(properties, propertyKey);
        if (charOrNull == null) {
            return defaultValue;
        }
        if (charOrNull.length() != 1 && loggerOrNull != null) {
            loggerOrNull.log(LogLevel.INFO, String.format(NON_CHAR_VALUE_FORMAT, charOrNull, Character.valueOf(defaultValue)));
            return defaultValue;
        }
        return charOrNull.charAt(0);
    }

    public static final boolean getBoolean(Properties properties, String propertyKey, boolean defaultValue) {
        return PropertyUtils.getBoolean(properties, propertyKey, defaultValue, null);
    }

    public static final void trimProperties(Properties properties) {
        assert (properties != null) : "Unspecified properties";
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            properties.setProperty(key, StringUtils.trim((String)properties.getProperty(key)));
        }
    }

    public static final Properties loadProperties(String propertiesFilePath) {
        try {
            return PropertyUtils.loadProperties(new FileInputStream(propertiesFilePath), propertiesFilePath);
        }
        catch (FileNotFoundException ex) {
            String msg = String.format("Properties file '%s' not found.", propertiesFilePath);
            throw new ConfigurationFailureException(msg, ex);
        }
    }

    public static final Properties loadProperties(InputStream is, String resourceName) {
        assert (is != null) : "No input stream specified";
        Properties properties = new Properties();
        try {
            properties.load(is);
            PropertyUtils.trimProperties(properties);
            Properties properties2 = properties;
            return properties2;
        }
        catch (Exception ex) {
            String msg = String.format("Could not load the properties from given resource '%s'.", resourceName);
            throw new ConfigurationFailureException(msg, ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public static Properties loadProperties(File propertiesFile) {
        Properties properties = new Properties();
        List<String> lines = FileUtilities.loadToStringList(propertiesFile);
        int i = 0;
        while (i < lines.size()) {
            String line = lines.get(i);
            if (line.length() != 0 && !line.startsWith("#")) {
                int indexOfEqualSymbol = line.indexOf(61);
                if (indexOfEqualSymbol < 0) {
                    throw new UserFailureException("Missing '=' in line " + (i + 1) + " of properties file '" + propertiesFile + "': " + line);
                }
                String key = line.substring(0, indexOfEqualSymbol).trim();
                String value = line.substring(indexOfEqualSymbol + 1).trim();
                properties.setProperty(key, value);
            }
            ++i;
        }
        return properties;
    }

    public static void saveProperties(File propertiesFile, Properties properties) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            builder.append(key);
            builder.append(" = ");
            builder.append(value);
            builder.append('\n');
        }
        FileUtilities.writeToFile(propertiesFile, builder.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Boolean {
        TRUE("1", "yes", "true"),
        FALSE("0", "no", "false");

        private final String[] values;

        private Boolean(String ... values) {
            this.values = values;
        }

        public static final Boolean getBoolean(String value) {
            if (Boolean.contains(Boolean.TRUE.values, value)) {
                return TRUE;
            }
            if (Boolean.contains(Boolean.FALSE.values, value)) {
                return FALSE;
            }
            return null;
        }

        public final boolean toBoolean() {
            return Boolean.toBoolean(this);
        }

        public static final boolean toBoolean(Boolean bool) {
            return bool == TRUE;
        }

        private static final boolean contains(String[] values, String value) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.equalsIgnoreCase(value)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

