/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.utilities.OSUtilities;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtilities {
    private static final String[] STRINGS = new String[]{"phalanx", "nightmare", "concierge", "asbestos", "cody", "hermit", "nbc", "couplet", "dice", "thumbnail", "finley", "figure", "exclamation", "whoosh", "punish", "servitor", "portend", "boulevard", "bacterial", "dilate", "emboss", "birmingham", "illustrate", "pomona", "truk", "bursitis", "trustworthy", "harriman", "schenectady", "obligate", "oceania", "knew", "quickstep", "woo", "strickland", "sadie", "malabar", "posit", "breadfruit", "grandfather", "vishnu", "vacuous", "melpomene", "assam", "blaine", "taskmaster", "polymeric", "hector", "counterrevolution", "compassionate", "linkage", "distant", "vet", "shako", "eagan", "neutronium", "stony", "lie", "hoydenish", "dial", "hecate", "pinch", "olin", "piglet", "basswood", "yawn", "ouzo", "scrupulosity", "bestiary", "subpoena", "nudge", "baton", "thing", "hallmark", "bossy", "preferential", "bambi", "narwhal", "brighten", "omnipotent", "forsake", "flapping", "orthodoxy", "upcome", "teaspoonful", "wabash", "lipid", "enjoin", "shoshone", "wartime", "gatekeeper", "litigate", "siderite", "sadden", "visage", "boogie", "scald", "equate", "tragic", "ordinary", "wick", "gigawatt", "desultory", "bambi", "aureomycin", "car", "especial", "rescue", "protector", "burnett", "constant", "heroes", "filmstrip", "homeown", "verdant", "governor", "cornwall", "predisposition", "sedan", "resemblant", "satellite", "committeemen", "given", "narragansett", "switzer", "clockwatcher", "sweeten", "monologist", "execrate", "gila", "lad", "mahayanist", "solicitation", "linemen", "reading", "hoard", "phyla", "carcinoma", "glycol", "polymer", "hangmen", "dualism", "betrayal", "corpsman", "stint", "hannah", "balsam", "granola", "charitable", "osborn", "party", "laboratory", "norwich", "laxative", "collude", "rockefeller", "crack", "lamarck", "purposeful", "neuroanotomy", "araby", "crucible", "oratorical", "dramaturgy", "kitty", "pit", "ephesus", "bum", "amuse", "clogging", "joker", "fobbing", "extent", "colossal", "macromolecule", "choppy", "tennessee", "primrose", "glassine", "vampire", "chap", "precursor", "incorrigible", "slither", "interrogate", "spectral", "debut", "creche", "pyrolysis", "homicidal", "sonnet", "gin", "science", "magma", "metaphor", "cobble", "dyer", "narrate", "goody", "optometric"};
    private static final Pattern matrixSplitPattern = Pattern.compile("([a-zA-Z]+)([0-9]+)");
    private static final Pattern ONE_OR_MORE_DIGITS = Pattern.compile(".*(\\d+)$");

    private StringUtilities() {
    }

    public static String computeMD5Hash(String string) {
        assert (string != null) : "Unspecified string.";
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(string.getBytes("utf8"));
            byte[] messageDigest = algorithm.digest();
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < messageDigest.length) {
                byte b = messageDigest[i];
                builder.append(Integer.toHexString(0xF & b >> 4));
                builder.append(Integer.toHexString(0xF & b));
                ++i;
            }
            return builder.toString();
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    public static String capitalize(String string) {
        if (StringUtils.isBlank((String)string)) {
            return string;
        }
        return String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1).toLowerCase();
    }

    public static String concatenateWithSpace(List<String> list) {
        return StringUtils.join(list, (String)" ");
    }

    public static String concatenateWithNewLine(List<String> list) {
        return StringUtils.join(list, (String)OSUtilities.LINE_SEPARATOR);
    }

    public static final String[] getStrings(int numberOfStrings) {
        String[] result = new String[numberOfStrings];
        int i = 0;
        while (i < numberOfStrings) {
            result[i] = StringUtilities.getString();
            ++i;
        }
        return result;
    }

    public static final String getString() {
        return STRINGS[(int)(Math.random() * (double)STRINGS.length - 1.0)];
    }

    public static final String[] splitMatrixCoordinate(String text) {
        assert (text != null) : "Given text can not be null.";
        Matcher matcher = matrixSplitPattern.matcher(text);
        if (matcher.matches()) {
            return new String[]{matcher.group(1), matcher.group(2)};
        }
        return null;
    }

    public static final String getOrdinal(int number) {
        assert (number >= 0) : "Given number must be >= 0.";
        int modulo = number % 100;
        if (modulo < 11 || modulo > 13) {
            modulo = number % 10;
            switch (modulo) {
                case 1: {
                    return String.valueOf(number) + "st";
                }
                case 2: {
                    return String.valueOf(number) + "nd";
                }
                case 3: {
                    return String.valueOf(number) + "rd";
                }
            }
        }
        return String.valueOf(number) + "th";
    }

    public static int compareNullable(String s1OrNull, String s2OrNull) {
        if (s1OrNull == null) {
            return s2OrNull == null ? 0 : -1;
        }
        if (s2OrNull == null) {
            return 1;
        }
        return s1OrNull.compareTo(s2OrNull);
    }

    public static List<String> tokenize(String textOrNull) {
        ArrayList<String> list = new ArrayList<String>();
        if (textOrNull != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(textOrNull, ", \t\n\r\f");
            while (stringTokenizer.hasMoreTokens()) {
                list.add(stringTokenizer.nextToken());
            }
        }
        return list;
    }

    public static final String createUniqueString(String str, IUniquenessChecker checker) {
        return StringUtilities.createUniqueString(str, checker, null, null);
    }

    public static final String createUniqueString(String str, IUniquenessChecker checker, Pattern regexOrNull, String defaultStrOrNull) {
        Pattern pattern;
        assert (str != null);
        assert (checker != null);
        if (checker.isUnique(str)) {
            return str;
        }
        if (regexOrNull == null) {
            pattern = ONE_OR_MORE_DIGITS;
        } else {
            assert (regexOrNull.pattern().indexOf("(\\d+)") > -1 || regexOrNull.pattern().indexOf("([0-9]+)") > -1);
            pattern = regexOrNull;
        }
        Matcher matcher = pattern.matcher(str);
        boolean found = matcher.find();
        if (!found) {
            String newStr = !StringUtils.isEmpty((String)defaultStrOrNull) ? defaultStrOrNull : String.valueOf(str) + "1";
            return StringUtilities.createUniqueString(newStr, checker, pattern, defaultStrOrNull);
        }
        StringBuilder builder = new StringBuilder();
        int nextStart = 0;
        while (found) {
            String group = matcher.group(1);
            int newNumber = Integer.parseInt(group) + 1;
            builder.append(str.substring(nextStart, matcher.start(1))).append(newNumber);
            nextStart = matcher.end(1);
            found = matcher.find();
        }
        builder.append(str.substring(nextStart));
        String newStr = builder.toString();
        if (!checker.isUnique(newStr)) {
            return StringUtilities.createUniqueString(newStr, checker, pattern, defaultStrOrNull);
        }
        return newStr;
    }

    public static interface IUniquenessChecker {
        public boolean isUnique(String var1);
    }
}

