/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.cli;

import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.client.api.cli.AbstractDataSetExecutor;
import ch.systemsx.cisd.openbis.dss.client.api.cli.AbstractDssCommand;
import ch.systemsx.cisd.openbis.dss.client.api.cli.DataSetArguments;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ResultCode;
import ch.systemsx.cisd.openbis.dss.client.api.v1.FileInfoDssDownloader;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDataSetDss;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommandGet
extends AbstractDssCommand<CommandGetArguments> {
    CommandGet() {
        super(new CommandGetArguments());
    }

    @Override
    public ResultCode execute(String[] args) throws UserFailureException, EnvironmentFailureException {
        return new CommandGetExecutor((CommandGetArguments)this.arguments, this).execute(args);
    }

    @Override
    public String getName() {
        return "get";
    }

    static class CommandGetArguments
    extends DataSetArguments {
        @Option(name="l", longName="link", usage="Try to return a link to the data set in the DSS if possible, download the entire data set otherwise.")
        private boolean link = false;
        @Option(name="e", longName="store-override", usage="An alternative path to the DSS Store root (only applicable with the link option)")
        private String storeOverride = "";
        @Option(name="o", longName="output", usage="Path for output")
        private String output = "";

        CommandGetArguments() {
        }

        public String getOutput() {
            return this.output;
        }

        public boolean isLink() {
            return this.link;
        }

        public String getStoreOverride() {
            return this.storeOverride;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommandGetExecutor
    extends AbstractDataSetExecutor<CommandGetArguments> {
        CommandGetExecutor(CommandGetArguments arguments, AbstractDssCommand<CommandGetArguments> command) {
            super(arguments, command);
        }

        @Override
        protected void handle(FileInfoDssDTO[] fileInfos, IDataSetDss dataSet) {
            if (((CommandGetArguments)this.arguments).isLink()) {
                this.handleLink(dataSet);
            } else {
                this.handleDownload(fileInfos, dataSet);
            }
        }

        private void handleLink(IDataSetDss dataSet) {
            File outputDir = this.getOutputDir();
            String storeOverride = null;
            if (((CommandGetArguments)this.arguments).getStoreOverride().length() > 0) {
                storeOverride = ((CommandGetArguments)this.arguments).getStoreOverride();
            }
            File result = dataSet.getLinkOrCopyOfContents(storeOverride, outputDir);
            this.printResultFile(result);
        }

        private void handleDownload(FileInfoDssDTO[] fileInfos, IDataSetDss dataSet) {
            File outputDir = this.getOutputDir();
            outputDir.mkdirs();
            this.printResultFile(outputDir);
            FileInfoDssDownloader downloader = new FileInfoDssDownloader(dataSet, fileInfos, outputDir, new DownloaderListener(outputDir));
            downloader.downloadFiles();
        }

        public File getOutputDir() {
            File outputDir = ((CommandGetArguments)this.arguments).getOutput().length() > 0 ? new File(((CommandGetArguments)this.arguments).getOutput()) : new File(".");
            return outputDir;
        }

        private void printResultFile(File result) {
            System.out.println("output dir :  " + result.getPath());
        }
    }

    private static class DownloaderListener
    implements FileInfoDssDownloader.FileInfoDssDownloaderListener {
        private final File targetDir;

        DownloaderListener(File targetDir) {
            this.targetDir = targetDir;
        }

        public void willDownload(FileInfoDssDTO fileInfo) {
            System.out.println("downloading " + this.getPathForFileInfo(fileInfo));
        }

        public void willCreateDirectory(FileInfoDssDTO fileInfo) {
            System.out.println("mkdir " + this.getPathForFileInfo(fileInfo));
        }

        public void didFinish() {
            System.out.println("Finished.");
        }

        private String getPathForFileInfo(FileInfoDssDTO fileInfo) {
            return String.valueOf(this.targetDir.getPath()) + "/" + fileInfo.getPathInListing();
        }
    }
}

