/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.cli;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.client.api.cli.AbstractDataSetExecutor;
import ch.systemsx.cisd.openbis.dss.client.api.cli.AbstractDssCommand;
import ch.systemsx.cisd.openbis.dss.client.api.cli.DataSetArguments;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ResultCode;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDataSetDss;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommandLs
extends AbstractDssCommand<DataSetArguments> {
    CommandLs() {
        super(new DataSetArguments());
    }

    @Override
    public ResultCode execute(String[] args) throws UserFailureException, EnvironmentFailureException {
        return new CommandLsExecutor((DataSetArguments)this.arguments, this).execute(args);
    }

    @Override
    public String getName() {
        return "ls";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommandLsExecutor
    extends AbstractDataSetExecutor<DataSetArguments> {
        CommandLsExecutor(DataSetArguments arguments, AbstractDssCommand<DataSetArguments> command) {
            super(arguments, command);
        }

        @Override
        protected void handle(FileInfoDssDTO[] fileInfos, IDataSetDss dataSet) {
            FileInfoDssDTO[] fileInfoDssDTOArray = fileInfos;
            int n = fileInfos.length;
            int n2 = 0;
            while (n2 < n) {
                FileInfoDssDTO fileInfo = fileInfoDssDTOArray[n2];
                StringBuilder sb = new StringBuilder();
                if (fileInfo.isDirectory()) {
                    sb.append(" \t");
                } else {
                    sb.append(fileInfo.getFileSize());
                    sb.append("\t");
                }
                sb.append(fileInfo.getPathInListing());
                System.out.println(sb.toString());
                ++n2;
            }
        }
    }
}

