/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.cli;

import ch.systemsx.cisd.args4j.ExampleMode;
import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.client.api.cli.AbstractDssCommand;
import ch.systemsx.cisd.openbis.dss.client.api.cli.AbstractExecutor;
import ch.systemsx.cisd.openbis.dss.client.api.cli.GlobalArguments;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ResultCode;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDataSetDss;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDssComponent;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssBuilder;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation.ValidationError;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommandPut
extends AbstractDssCommand<CommandPutArguments> {
    CommandPut() {
        super(new CommandPutArguments());
    }

    @Override
    public ResultCode execute(String[] args) throws UserFailureException, EnvironmentFailureException {
        return new CommandPutExecutor((CommandPutArguments)this.arguments, this).execute(args);
    }

    @Override
    public String getName() {
        return "put";
    }

    @Override
    public void printUsage(PrintStream out) {
        out.println(String.valueOf(this.getUsagePrefixString()) + " [options] <owner type> <owner> <path>");
        this.parser.printUsage((OutputStream)out);
        out.println("  Examples : ");
        out.println("     " + this.getCommandCallString() + this.parser.printExample(ExampleMode.ALL) + " EXPERIMENT <experiment identifier> <path>");
        out.println("     " + this.getCommandCallString() + this.parser.printExample(ExampleMode.ALL) + " SAMPLE <sample identifier> <path>");
        out.println("     " + this.getCommandCallString() + this.parser.printExample(ExampleMode.ALL) + " DATA_SET <data set identifier> <path>");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CommandPutArguments
    extends GlobalArguments {
        @Option(name="t", longName="type", usage="Set the data set type")
        private String dataSetType;
        @Option(longName="props", usage="Set properties of the data set (format: code=val[,code=val]*")
        private String propertiesString;

        CommandPutArguments() {
        }

        public String getDataSetType() {
            return this.dataSetType;
        }

        public NewDataSetDTO.DataSetOwnerType getOwnerType() {
            return NewDataSetDTO.DataSetOwnerType.valueOf(this.getArguments().get(0).toString().toUpperCase());
        }

        public String getOwnerIdentifier() {
            return this.getArguments().get(1);
        }

        public String getFilePath() {
            return this.getArguments().get(2);
        }

        public File getFile() {
            return new File(this.getFilePath());
        }

        public HashMap<String, String> getProperties() {
            String[] propsArray;
            HashMap<String, String> propsMap = new HashMap<String, String>();
            String propsString = this.propertiesString;
            if (propsString == null || propsString.length() == 0) {
                return propsMap;
            }
            String[] stringArray = propsArray = propsString.split(",");
            int n = propsArray.length;
            int n2 = 0;
            while (n2 < n) {
                String propLine = stringArray[n2];
                String[] keyAndValue = propLine.split("=");
                assert (keyAndValue.length == 2);
                propsMap.put(keyAndValue[0], keyAndValue[1]);
                ++n2;
            }
            return propsMap;
        }

        @Override
        public boolean isComplete() {
            if (this.getArguments().size() < 3) {
                return false;
            }
            try {
                this.getOwnerType();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            try {
                this.getProperties();
            }
            catch (Exception exception) {
                System.err.println("\nProprties must be specified using as code=value[,code=value]*\n");
                return false;
            }
            return super.isComplete();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommandPutExecutor
    extends AbstractExecutor<CommandPutArguments> {
        CommandPutExecutor(CommandPutArguments arguments, AbstractDssCommand<CommandPutArguments> command) {
            super(arguments, command);
        }

        @Override
        protected ResultCode doExecute(IDssComponent component) {
            block9: {
                try {
                    NewDataSetDTO newDataSet = this.getNewDataSet();
                    if (newDataSet.getFileInfos().isEmpty()) {
                        File file = ((CommandPutArguments)this.arguments).getFile();
                        if (!file.exists()) {
                            System.err.println("Data set file does not exist");
                        } else if (!file.isDirectory()) {
                            System.err.println("Must select a directory to upload.");
                        } else {
                            System.err.println("Data set is empty.");
                        }
                        return ResultCode.INVALID_ARGS;
                    }
                    List<ValidationError> errors = component.validateDataSet(newDataSet, ((CommandPutArguments)this.arguments).getFile());
                    if (errors.isEmpty()) {
                        IDataSetDss dataSet = component.putDataSet(newDataSet, ((CommandPutArguments)this.arguments).getFile());
                        System.out.println("Registered new data set " + dataSet.getCode());
                        break block9;
                    }
                    System.out.println("Data set has errors:");
                    for (ValidationError error : errors) {
                        System.out.println("\t" + error.getErrorMessage());
                    }
                    return ResultCode.USER_ERROR;
                }
                catch (IOException e) {
                    throw new IOExceptionUnchecked(e);
                }
            }
            return ResultCode.OK;
        }

        private NewDataSetDTO getNewDataSet() throws IOException {
            NewDataSetDTO.DataSetOwnerType ownerType = ((CommandPutArguments)this.arguments).getOwnerType();
            String ownerIdentifier = ((CommandPutArguments)this.arguments).getOwnerIdentifier();
            NewDataSetDTO.DataSetOwner owner = new NewDataSetDTO.DataSetOwner(ownerType, ownerIdentifier);
            File file = ((CommandPutArguments)this.arguments).getFile();
            ArrayList<FileInfoDssDTO> fileInfos = this.getFileInfosForPath(file);
            String folderNameOrNull = null;
            if (file.isDirectory()) {
                folderNameOrNull = file.getName();
            }
            NewDataSetDTO dataSet = new NewDataSetDTO(owner, folderNameOrNull, fileInfos);
            dataSet.setDataSetTypeOrNull(((CommandPutArguments)this.arguments).getDataSetType());
            dataSet.setProperties(((CommandPutArguments)this.arguments).getProperties());
            return dataSet;
        }

        private ArrayList<FileInfoDssDTO> getFileInfosForPath(File file) throws IOException {
            ArrayList<FileInfoDssDTO> fileInfos = new ArrayList<FileInfoDssDTO>();
            if (!file.exists()) {
                return fileInfos;
            }
            String path = file.getCanonicalPath();
            if (!file.isDirectory()) {
                File parentFile = file.getParentFile();
                if (parentFile == null) {
                    parentFile = new File(".");
                }
                path = parentFile.getCanonicalPath();
            }
            FileInfoDssBuilder builder = new FileInfoDssBuilder(path, path);
            builder.appendFileInfosForFile(file, fileInfos, true);
            return fileInfos;
        }
    }
}

