/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.cli;

import ch.systemsx.cisd.openbis.dss.client.api.cli.AbstractCommandFactory;
import ch.systemsx.cisd.openbis.dss.client.api.cli.CommandHelp;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ICommand;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ICommandFactory;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeCommandFactory
extends AbstractCommandFactory {
    private final String programCallString;
    private final List<ICommandFactory> factories;

    public CompositeCommandFactory(String programCallString, List<ICommandFactory> factories) {
        this.programCallString = programCallString;
        this.factories = factories;
        assert (factories.size() > 0) : "CompositeCommandFactory must have a factory to wrap.";
        for (ICommandFactory factory : factories) {
            factory.setParentCommandFactory(this);
        }
    }

    @Override
    public List<String> getKnownCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        for (ICommandFactory factory : this.factories) {
            commands.addAll(factory.getKnownCommands());
        }
        return commands;
    }

    @Override
    public ICommand getHelpCommand() {
        return new CommandHelp(this, this.programCallString);
    }

    @Override
    public ICommand tryCommandForName(String name) {
        for (ICommandFactory factory : this.factories) {
            ICommand command = factory.tryCommandForName(name);
            if (command == null) continue;
            return command;
        }
        return null;
    }
}

