/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.cli;

import ch.systemsx.cisd.openbis.dss.client.api.cli.AbstractCommandFactory;
import ch.systemsx.cisd.openbis.dss.client.api.cli.CommandGet;
import ch.systemsx.cisd.openbis.dss.client.api.cli.CommandLs;
import ch.systemsx.cisd.openbis.dss.client.api.cli.CommandPut;
import ch.systemsx.cisd.openbis.dss.client.api.cli.CommandTestExtractMetadata;
import ch.systemsx.cisd.openbis.dss.client.api.cli.CommandTestValid;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ICommand;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DssCommandFactory
extends AbstractCommandFactory {
    static final String PROGRAM_CALL_STRING = "dss_client.sh";

    @Override
    public ICommand tryCommandForName(String name) {
        ICommand result;
        Command command;
        ICommand helpCommandOrNull = this.tryHelpCommandForName(name);
        if (helpCommandOrNull != null) {
            return helpCommandOrNull;
        }
        try {
            command = Command.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        switch (command) {
            case LS: {
                result = new CommandLs();
                break;
            }
            case GET: {
                result = new CommandGet();
                break;
            }
            case HELP: {
                result = this.getHelpCommand();
                break;
            }
            case PUT: {
                result = new CommandPut();
                break;
            }
            case TESTVALID: {
                result = new CommandTestValid();
                break;
            }
            case TESTEXTRACT: {
                result = new CommandTestExtractMetadata();
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    @Override
    public ICommand getHelpCommand() {
        return this.getHelpCommand(PROGRAM_CALL_STRING);
    }

    @Override
    public List<String> getKnownCommands() {
        String[] commands = new String[]{"ls", "get", "put", "testvalid", "testextract"};
        return Arrays.asList(commands);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Command {
        LS,
        GET,
        HELP,
        PUT,
        TESTVALID,
        TESTEXTRACT;

    }
}

