/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.openbis.dss.client.api.gui.AbstractSwingGUI;
import ch.systemsx.cisd.openbis.dss.client.api.gui.DataSetMetadataPanel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.DataSetUploadClientModel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.DataSetUploadTableModel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.DssCommunicationState;
import ch.systemsx.cisd.openbis.dss.client.api.gui.UploadStatusTableCellEditor;
import ch.systemsx.cisd.openbis.dss.client.api.gui.UploadStatusTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PySystemState;

public class DataSetUploadClient
extends AbstractSwingGUI {
    public static final int BUTTON_WIDTH = 120;
    public static final int LABEL_WIDTH = 110;
    public static final int BUTTON_HEIGHT = 30;
    private static final String TITLE = "Data Set Uploader";
    private final DataSetUploadClientModel clientModel;
    private final DataSetUploadTableModel tableModel;
    private final DataSetMetadataPanel metadataPanel;

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
    }

    private static void initializeJythonWebStartWorkaround() {
        PySystemState.initialize();
        Py.getSystemState().path.append((PyObject)Py.newString((String)"__pyclasspath__/Lib"));
    }

    public static void main(String[] args) throws UserFailureException, EnvironmentFailureException {
        DataSetUploadClient.setLookAndFeelToMetal();
        try {
            DataSetUploadClient.initializeJythonWebStartWorkaround();
            DssCommunicationState commState = new DssCommunicationState(args);
            DataSetUploadClient newMe = new DataSetUploadClient(commState, SystemTimeProvider.SYSTEM_TIME_PROVIDER);
            newMe.show();
        }
        catch (RuntimeException ex) {
            JFrame frame = new JFrame(TITLE);
            frame.setVisible(true);
            String message = ex.getMessage();
            if (message == null || message.length() == 0) {
                message = ex.toString();
            }
            JOptionPane.showMessageDialog(frame, message, "Error", 0);
            System.exit(1);
        }
    }

    DataSetUploadClient(DssCommunicationState commState, ITimeProvider timeProvider) {
        super(commState);
        this.clientModel = new DataSetUploadClientModel(commState, timeProvider);
        this.metadataPanel = new DataSetMetadataPanel(this.clientModel, this.getWindowFrame());
        this.tableModel = new DataSetUploadTableModel(this, this.clientModel, this.metadataPanel, this.getWindowFrame());
        this.clientModel.setTableModel(this.tableModel);
        this.createGui();
        this.addProgressListener();
    }

    private void createGui() {
        JFrame window = this.getWindowFrame();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.5;
        c.weighty = 0.0;
        panel.add(this.createGlobalActionsPanel(), c);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.5;
        c.weighty = 0.5;
        panel.add((Component)this.createFileListComponent(), c);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.5;
        c.weighty = 0.5;
        panel.add((Component)this.metadataPanel, c);
        window.add((Component)panel, "Center");
        JLabel spacer = new JLabel("");
        spacer.setPreferredSize(new Dimension(5, 5));
        window.add((Component)spacer, "West");
        spacer = new JLabel("");
        spacer.setPreferredSize(new Dimension(5, 5));
        window.add((Component)spacer, "East");
        spacer = new JLabel("");
        spacer.setPreferredSize(new Dimension(15, 15));
        window.add((Component)spacer, "South");
        window.pack();
        window.setBounds(20, 40, 600, 450);
        window.setLocationByPlatform(true);
        window.setVisible(true);
        this.tableModel.addNewDataSet();
    }

    private Component createGlobalActionsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        JButton addButton = new JButton("+");
        addButton.setPreferredSize(new Dimension(50, 30));
        addButton.setToolTipText("Add a new data set");
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataSetUploadClient.this.tableModel.addNewDataSet();
            }
        });
        JButton removeButton = new JButton("-");
        removeButton.setPreferredSize(new Dimension(50, 30));
        removeButton.setToolTipText("Remove the selected data set");
        removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataSetUploadClient.this.tableModel.removeSelectedDataSet();
            }
        });
        JButton uploadAllButton = new JButton("Upload All");
        uploadAllButton.setPreferredSize(new Dimension(120, 30));
        uploadAllButton.setToolTipText("Attach the data set to a sample.");
        uploadAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataSetUploadClient.this.clientModel.queueUploadOfDataSet(DataSetUploadClient.this.clientModel.getNewDataSetInfos());
            }
        });
        panel.add(addButton);
        panel.add(removeButton);
        panel.add(Box.createHorizontalGlue());
        panel.add(uploadAllButton);
        return panel;
    }

    private JComponent createFileListComponent() {
        JTable fileTable = new JTable(this.tableModel){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                JComponent jc = (JComponent)c;
                jc.setBorder(new MatteBorder(0, 0, 1, 1, Color.LIGHT_GRAY));
                return c;
            }
        };
        fileTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel selectionModel = (ListSelectionModel)e.getSource();
                ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
                if (!selectionModel.isSelectionEmpty()) {
                    int minIndex = selectionModel.getMinSelectionIndex();
                    int maxIndex = selectionModel.getMaxSelectionIndex();
                    int i = minIndex;
                    while (i <= maxIndex) {
                        if (selectionModel.isSelectedIndex(i)) {
                            selectedIndices.add(i);
                        }
                        ++i;
                    }
                }
                DataSetUploadClient.this.tableModel.setSelectedIndices(selectedIndices);
            }
        });
        this.tableModel.setTable(fileTable);
        fileTable.setRowHeight(fileTable.getRowHeight() * 2);
        TableColumn column = fileTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(320);
        column = fileTable.getColumnModel().getColumn(1);
        column.setPreferredWidth(150);
        column = fileTable.getColumnModel().getColumn(2);
        column.setPreferredWidth(150);
        column = fileTable.getColumnModel().getColumn(3);
        column.setPreferredWidth(200);
        column = fileTable.getColumnModel().getColumn(4);
        column.setPreferredWidth(200);
        column.setCellRenderer(new UploadStatusTableCellRenderer(this.tableModel));
        column.setCellEditor(new UploadStatusTableCellEditor(this.tableModel));
        JScrollPane scrollPane = new JScrollPane(fileTable);
        return scrollPane;
    }

    private void addProgressListener() {
    }

    private void show() {
        this.getWindowFrame().setVisible(true);
    }

    protected final boolean cancel() {
        int answer = JOptionPane.showConfirmDialog(this.getWindowFrame(), "Do you really want to stop uploading?");
        return answer == 0;
    }

    protected String getTitle() {
        return TITLE;
    }
}

