/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui;

import ch.systemsx.cisd.openbis.dss.client.api.gui.DataSetMetadataPanel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.DataSetUploadClient;
import ch.systemsx.cisd.openbis.dss.client.api.gui.DataSetUploadClientModel;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTOBuilder;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetUploadTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    static final int DATA_SET_OWNER_COLUMN = 0;
    static final int DATA_SET_TYPE_COLUMN = 1;
    static final int DATA_SET_METADATA_COLUMN = 2;
    static final int DATA_SET_PATH_COLUMN = 3;
    static final int UPLOAD_STATUS_COLUMN = 4;
    private final JFrame mainWindow;
    private final DataSetUploadClientModel clientModel;
    private final DataSetMetadataPanel metadataPanel;
    private final ArrayList<DataSetUploadClientModel.NewDataSetInfo> newDataSetInfos = new ArrayList();
    private JTable table;
    private int sortColumnIndex = 0;
    private boolean sortAscending = true;
    private int selectedRow = -1;

    DataSetUploadTableModel(DataSetUploadClient downloadClient, DataSetUploadClientModel clientModel, DataSetMetadataPanel metadataPanel, JFrame mainWindow) {
        this.mainWindow = mainWindow;
        this.clientModel = clientModel;
        this.metadataPanel = metadataPanel;
    }

    public void setTable(JTable table) {
        this.table = table;
        table.getTableHeader().addMouseListener(new ColumnSortingListener());
    }

    void fireChanged(DataSetUploadClientModel.NewDataSetInfo newDataSetInfo, DataSetUploadClientModel.NewDataSetInfo.Status newStatus) {
        int index = this.newDataSetInfos.indexOf(newDataSetInfo);
        this.fireTableRowsUpdated(index, index);
    }

    void setSelectedIndices(ArrayList<Integer> selectedIndices) {
        if (selectedIndices.size() < 1) {
            this.selectNewDataSetInfo(null);
            return;
        }
        this.selectedRow = selectedIndices.get(0);
        DataSetUploadClientModel.NewDataSetInfo selectedDataSet = this.getSelectedNewDataSetOrNull();
        this.selectNewDataSetInfo(selectedDataSet);
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public int getRowCount() {
        return this.newDataSetInfos.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        String name = "";
        if (columnIndex == this.sortColumnIndex) {
            name = this.sortAscending ? "\u25b2" : "\u25bc";
        }
        switch (columnIndex) {
            case 0: {
                name = String.valueOf(name) + " Owner";
                break;
            }
            case 1: {
                name = String.valueOf(name) + " Type";
                break;
            }
            case 2: {
                name = String.valueOf(name) + " Metadata";
                break;
            }
            case 3: {
                name = String.valueOf(name) + " Path";
                break;
            }
        }
        return name;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        DataSetUploadClientModel.NewDataSetInfo newDataSetInfo = this.newDataSetInfos.get(rowIndex);
        NewDataSetDTOBuilder builder = newDataSetInfo.getNewDataSetBuilder();
        switch (columnIndex) {
            case 0: {
                NewDataSetDTO.DataSetOwner owner = builder.getDataSetOwner();
                return (Object)((Object)owner.getType()) + ":" + this.untouchedStringOrEmpty(owner.getIdentifier());
            }
            case 1: {
                return this.untouchedStringOrEmpty(builder.getDataSetMetadata().tryDataSetType());
            }
            case 2: {
                return builder.getDataSetMetadata().getProperties();
            }
            case 3: {
                File file = builder.getFile();
                return file == null ? "" : file.getName();
            }
            case 4: {
                return newDataSetInfo;
            }
        }
        return null;
    }

    private String untouchedStringOrEmpty(String aString) {
        return aString == null ? "" : aString;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        Object columnValue = this.getValueAt(0, c);
        if (columnValue == null) {
            return super.getColumnClass(c);
        }
        return columnValue.getClass();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        assert (col == 4);
        DataSetUploadClientModel.NewDataSetInfo newDataSetInfo = (DataSetUploadClientModel.NewDataSetInfo)value;
        if (newDataSetInfo == null) {
            return;
        }
        DataSetUploadClientModel.NewDataSetInfo.Status status = newDataSetInfo.getStatus();
        if (status != DataSetUploadClientModel.NewDataSetInfo.Status.TO_UPLOAD && status != DataSetUploadClientModel.NewDataSetInfo.Status.FAILED) {
            return;
        }
        this.queueUploadOfDataSet(newDataSetInfo);
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex != 4) {
            return false;
        }
        DataSetUploadClientModel.NewDataSetInfo newDataSetInfo = this.newDataSetInfos.get(rowIndex);
        if (newDataSetInfo == null) {
            return false;
        }
        DataSetUploadClientModel.NewDataSetInfo.Status status = newDataSetInfo.getStatus();
        return status == DataSetUploadClientModel.NewDataSetInfo.Status.TO_UPLOAD || status == DataSetUploadClientModel.NewDataSetInfo.Status.FAILED || status == DataSetUploadClientModel.NewDataSetInfo.Status.COMPLETED_UPLOAD;
    }

    public JFrame getMainWindow() {
        return this.mainWindow;
    }

    public void selectedRowDataChanged() {
        if (this.selectedRow < 0) {
            return;
        }
        this.fireTableRowsUpdated(this.selectedRow, this.selectedRow);
    }

    public void addNewDataSet() {
        DataSetUploadClientModel.NewDataSetInfo newlyCreated = this.clientModel.addNewDataSetInfo(this.getSelectedNewDataSetOrNull());
        this.syncNewDataSetInfos();
        ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
        selectedIndices.add(this.clientModel.getNewDataSetInfos().size() - 1);
        this.setSelectedIndices(selectedIndices);
        this.selectNewDataSetInfo(newlyCreated);
        this.table.getSelectionModel().setSelectionInterval(selectedIndices.get(0), selectedIndices.get(0));
    }

    public void removeSelectedDataSet() {
        if (this.selectedRow < 0) {
            return;
        }
        if (this.selectedRow >= this.newDataSetInfos.size()) {
            return;
        }
        DataSetUploadClientModel.NewDataSetInfo dataSetInfoToRemove = this.getSelectedNewDataSetOrNull();
        int newSelectedRow = -1;
        ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
        selectedIndices.add(newSelectedRow);
        this.setSelectedIndices(selectedIndices);
        this.clientModel.removeNewDataSetInfo(dataSetInfoToRemove);
        this.syncNewDataSetInfos();
    }

    private void syncNewDataSetInfos() {
        this.newDataSetInfos.clear();
        this.newDataSetInfos.addAll(this.clientModel.getNewDataSetInfos());
        this.syncNewDataSetInfoListView();
    }

    private void syncNewDataSetInfoListView() {
        Collections.sort(this.newDataSetInfos, new NewDataSetInfoComparator());
        this.table.tableChanged(new TableModelEvent(this));
        this.table.repaint();
    }

    private void selectNewDataSetInfo(DataSetUploadClientModel.NewDataSetInfo newDataSetInfo) {
        this.metadataPanel.setNewDataSetInfo(newDataSetInfo);
    }

    private void queueUploadOfDataSet(DataSetUploadClientModel.NewDataSetInfo newDataSetInfo) {
        this.clientModel.queueUploadOfDataSet(newDataSetInfo);
    }

    public DataSetUploadClientModel.NewDataSetInfo getSelectedNewDataSetOrNull() {
        return this.selectedRow < 0 ? null : this.newDataSetInfos.get(this.selectedRow);
    }

    private class ColumnSortingListener
    extends MouseAdapter {
        private ColumnSortingListener() {
        }

        public void mouseClicked(MouseEvent e) {
            int columnModelIndex;
            TableColumnModel colModel = DataSetUploadTableModel.this.table.getColumnModel();
            int modelIndex = colModel.getColumn(columnModelIndex = colModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (modelIndex < 0) {
                return;
            }
            if (modelIndex == 2) {
                return;
            }
            if (DataSetUploadTableModel.this.sortColumnIndex == modelIndex) {
                DataSetUploadTableModel.this.sortAscending = !DataSetUploadTableModel.this.sortAscending;
            } else {
                DataSetUploadTableModel.this.sortColumnIndex = modelIndex;
                DataSetUploadTableModel.this.sortAscending = true;
            }
            int i = 0;
            while (i < DataSetUploadTableModel.this.getColumnCount()) {
                TableColumn column = colModel.getColumn(i);
                column.setHeaderValue(DataSetUploadTableModel.this.getColumnName(column.getModelIndex()));
                ++i;
            }
            DataSetUploadTableModel.this.table.getTableHeader().repaint();
            DataSetUploadTableModel.this.syncNewDataSetInfoListView();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NewDataSetInfoComparator
    implements Comparator<DataSetUploadClientModel.NewDataSetInfo> {
        private NewDataSetInfoComparator() {
        }

        @Override
        public int compare(DataSetUploadClientModel.NewDataSetInfo info1, DataSetUploadClientModel.NewDataSetInfo info2) {
            int result = 0;
            switch (DataSetUploadTableModel.this.sortColumnIndex) {
                case 0: {
                    String identifier1 = info1.getNewDataSetBuilder().getDataSetOwnerIdentifier();
                    String identifier2 = info2.getNewDataSetBuilder().getDataSetOwnerIdentifier();
                    result = identifier1.compareTo(identifier2);
                    break;
                }
                case 1: {
                    String type1 = info1.getNewDataSetBuilder().getDataSetMetadata().tryDataSetType();
                    String type2 = info2.getNewDataSetBuilder().getDataSetMetadata().tryDataSetType();
                    type1 = type1 == null ? "" : type1;
                    type2 = type2 == null ? "" : type2;
                    result = type1.compareTo(type2);
                    break;
                }
                case 3: {
                    File file1 = info1.getNewDataSetBuilder().getFile();
                    File file2 = info2.getNewDataSetBuilder().getFile();
                    String path1 = file1 != null ? file1.getAbsolutePath() : "";
                    String path2 = file2 != null ? file2.getAbsolutePath() : "";
                    result = path1.compareTo(path2);
                    break;
                }
                case 4: {
                    result = info1.getStatus().compareTo(info2.getStatus());
                }
            }
            return DataSetUploadTableModel.this.sortAscending ? result : -result;
        }
    }
}

