/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui;

import ch.systemsx.cisd.openbis.dss.client.api.gui.ErrorMessageDialog;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation.ValidationError;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ErrorsPanel
extends JPanel {
    private static final long serialVersionUID = 5932698456919803620L;
    private static final String VALIDATION_ERRORS_CARD = "Errors";
    private static final String VALIDATION_WAIT_CARD = "Wait";
    private static final String VALIDATION_SUCCESS_CARD = "Success";
    private static final ImageIcon OK_ICON = new ImageIcon(ErrorsPanel.class.getResource("/ok.png"));
    private static final ImageIcon WRONG_ICON = new ImageIcon(ErrorsPanel.class.getResource("/wrong.png"));
    private static final ImageIcon WAIT_ICON = new ImageIcon(ErrorsPanel.class.getResource("/wait.gif"));
    private final Set<String> errors = new LinkedHashSet<String>();
    private final ErrorMessageDialog errorMessageDialog;
    private final JScrollPane errorsAreaScroll;
    private final JPanel errorsPanel;

    public ErrorsPanel(JFrame mainWindow) {
        super(new CardLayout());
        this.errorMessageDialog = new ErrorMessageDialog(mainWindow);
        this.errorsPanel = new JPanel();
        this.errorsPanel.setLayout(new BoxLayout(this.errorsPanel, 1));
        this.errorsAreaScroll = new JScrollPane(this.errorsPanel);
        this.errorsAreaScroll.setBorder(BorderFactory.createEmptyBorder());
        this.errorsAreaScroll.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.errorsAreaScroll, VALIDATION_ERRORS_CARD);
        this.add((Component)new JLabel("Validating, please wait...", WAIT_ICON, 2), VALIDATION_WAIT_CARD);
        this.add((Component)new JLabel("Validated successfully.", OK_ICON, 2), VALIDATION_SUCCESS_CARD);
    }

    public void clear() {
        this.errors.clear();
        this.errorsPanel.removeAll();
        this.errorsPanel.invalidate();
        this.errorsPanel.getParent().validate();
    }

    public void reportError(ValidationError error) {
        this.errors.add(error.getErrorMessage());
        this.displayErrors();
    }

    private void displayErrors() {
        if (this.errors.isEmpty()) {
            return;
        }
        this.errorsPanel.removeAll();
        for (final String error : this.errors) {
            JPanel line = new JPanel(new FlowLayout(0));
            String truncateErrorMessage = this.truncateErrorMessage(error);
            JLabel label = new JLabel(truncateErrorMessage, WRONG_ICON, 2);
            line.add(label);
            if (truncateErrorMessage.length() < error.length()) {
                JButton button = new JButton("...");
                button.setPreferredSize(new Dimension(25, label.getPreferredSize().height));
                button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ErrorsPanel.this.errorMessageDialog.showErrorMessage(error);
                    }
                });
                line.add(button);
            }
            this.errorsPanel.add(line);
        }
        this.errorsPanel.invalidate();
        this.errorsPanel.getParent().validate();
    }

    private String truncateErrorMessage(String errorMessage) {
        int indexOfLF;
        int truncIndex = 80;
        int indexOfCR = errorMessage.indexOf(13);
        if (indexOfCR > -1 && indexOfCR < truncIndex) {
            truncIndex = indexOfCR;
        }
        if ((indexOfLF = errorMessage.indexOf(10)) > -1 && indexOfLF < truncIndex) {
            truncIndex = indexOfLF;
        }
        return errorMessage.length() > truncIndex ? errorMessage.substring(0, truncIndex) : errorMessage;
    }

    public void waitCard() {
        ((CardLayout)this.getLayout()).show(this, VALIDATION_WAIT_CARD);
    }

    public void showResult() {
        if (this.errors.isEmpty()) {
            ((CardLayout)this.getLayout()).show(this, VALIDATION_SUCCESS_CARD);
        } else {
            ((CardLayout)this.getLayout()).show(this, VALIDATION_ERRORS_CARD);
        }
    }
}

