/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui;

import ch.systemsx.cisd.common.collections.CollectionUtils;
import ch.systemsx.cisd.common.collections.IKeyExtractor;
import ch.systemsx.cisd.openbis.dss.client.api.v1.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadClientSortingUtils {
    public static void sortSamplesByIdentifier(List<Sample> samples) {
        CollectionUtils.sort(samples, new IKeyExtractor<String, Sample>(){

            @Override
            public String getKey(Sample sample) {
                return sample.getIdentifier();
            }
        });
    }

    public static void sortExperimentsByIdentifier(List<Experiment> samples) {
        CollectionUtils.sort(samples, new IKeyExtractor<String, Experiment>(){

            @Override
            public String getKey(Experiment experiment) {
                return experiment.getIdentifier();
            }
        });
    }

    public static void sortDataSetsByCode(List<DataSet> dataSets) {
        CollectionUtils.sort(dataSets, new IKeyExtractor<String, DataSet>(){

            @Override
            public String getKey(DataSet dataSet) {
                return dataSet.getCode();
            }
        });
    }
}

