/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui;

import ch.systemsx.cisd.openbis.dss.client.api.gui.AddVocabularyTermDialog;
import ch.systemsx.cisd.openbis.dss.client.api.gui.DataSetUploadClientModel;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ControlledVocabularyPropertyType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.VocabularyTerm;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VocabularyTermsComboBoxPanel
extends JPanel
implements DataSetUploadClientModel.Observer {
    private static final long serialVersionUID = 1L;
    private final JComboBox comboBox;
    private final JButton button = new JButton("+");
    private final Vocabulary vocabulary;

    public VocabularyTermsComboBoxPanel(ControlledVocabularyPropertyType propertyType, final DataSetUploadClientModel clientModel) {
        super(new BorderLayout());
        this.button.setMargin(new Insets(this.button.getMargin().top, 2, this.button.getMargin().bottom, 2));
        this.button.setFocusable(false);
        this.add((Component)this.button, "East");
        this.comboBox = new JComboBox();
        this.add((Component)this.comboBox, "Center");
        this.vocabulary = clientModel.getVocabulary(propertyType.getVocabulary().getCode());
        this.fillComboBoxWithTerms(this.vocabulary.getTerms(), null);
        this.comboBox.setRenderer(new VocabularyTermsRenderer());
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddVocabularyTermDialog dialog = new AddVocabularyTermDialog((JFrame)SwingUtilities.getRoot(VocabularyTermsComboBoxPanel.this), VocabularyTermsComboBoxPanel.this.comboBox.getModel(), VocabularyTermsComboBoxPanel.this.vocabulary, clientModel);
                dialog.setVisible(true);
            }
        });
    }

    private void fillComboBoxWithTerms(List<VocabularyTerm> terms, String selectedCodeOrNull) {
        this.comboBox.removeAllItems();
        for (VocabularyTerm term : terms) {
            VocabularyTermAdaptor adaptor = new VocabularyTermAdaptor(term);
            this.comboBox.addItem(adaptor);
            if (!adaptor.term.getCode().equals(selectedCodeOrNull)) continue;
            this.comboBox.setSelectedItem(adaptor);
        }
    }

    public int getItemCount() {
        return this.comboBox.getItemCount();
    }

    public VocabularyTerm getItemAt(int i) {
        return ((VocabularyTermAdaptor)this.comboBox.getItemAt(i)).term;
    }

    public void setSelectedIndex(int i) {
        this.comboBox.setSelectedIndex(i);
    }

    public void addItemListener(final ItemListener itemListener) {
        this.comboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                itemListener.itemStateChanged(new ItemEvent(e.getItemSelectable(), e.getID(), ((VocabularyTermAdaptor)e.getItem()).term, e.getStateChange()));
            }
        });
    }

    @Override
    public void setToolTipText(String text) {
        this.comboBox.setToolTipText(text);
    }

    @Override
    public void update(Vocabulary vocabulary, String code) {
        String selectedCode = vocabulary.getId() != this.vocabulary.getId() ? ((VocabularyTermAdaptor)this.comboBox.getSelectedItem()).term.getCode() : code;
        this.fillComboBoxWithTerms(vocabulary.getTerms(), selectedCode);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.comboBox.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    protected static final class VocabularyTermAdaptor {
        private final VocabularyTerm term;

        private VocabularyTermAdaptor(VocabularyTerm term) {
            this.term = term;
        }

        public String toString() {
            return this.term.getLabel();
        }

        public Long getOrdinal() {
            return this.term.getOrdinal();
        }
    }

    private static final class VocabularyTermsRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 1L;

        private VocabularyTermsRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            VocabularyTermAdaptor termAdaptor;
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof VocabularyTermAdaptor && (termAdaptor = (VocabularyTermAdaptor)value).term != null && !termAdaptor.term.isOfficial().booleanValue()) {
                result.setForeground(Color.GRAY);
                Font font = new Font(result.getFont().getName(), 2, result.getFont().getSize());
                result.setFont(font);
            }
            return result;
        }
    }
}

