/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui.tree;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterableMutableTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    private Pattern pattern = Pattern.compile(".*");
    private ArrayList<Object> filtered = new ArrayList();

    public FilterableMutableTreeNode(Object nodeValue) {
        super(nodeValue);
        this.filter(".*");
    }

    private synchronized Pattern getPattern() {
        return this.pattern;
    }

    private synchronized void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    private synchronized ArrayList<Object> getFiltered() {
        return this.filtered;
    }

    private synchronized void setFiltered(ArrayList<Object> filtered) {
        this.filtered = filtered;
    }

    public void filter(String filter) {
        Pattern pattern;
        try {
            pattern = Pattern.compile("(?i)" + filter);
        }
        catch (RuntimeException runtimeException) {
            pattern = Pattern.compile(".*");
        }
        this.setPattern(pattern);
        this.filter(pattern);
    }

    public void filter(Pattern pattern) {
        ArrayList<Object> filtered = new ArrayList<Object>();
        Enumeration<TreeNode> enumeration = super.children();
        while (enumeration.hasMoreElements()) {
            TreeNode o = enumeration.nextElement();
            if (!pattern.matcher(o.toString()).find()) continue;
            filtered.add(o);
        }
        this.setFiltered(filtered);
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        ArrayList<Object> filtered = this.getFiltered();
        if (filtered == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        return (TreeNode)filtered.get(childIndex);
    }

    @Override
    public int getChildCount() {
        ArrayList<Object> filtered = this.getFiltered();
        if (filtered == null) {
            return 0;
        }
        return filtered.size();
    }

    @Override
    public int getIndex(TreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(aChild)) {
            return -1;
        }
        return this.getFiltered().indexOf(aChild);
    }

    public Enumeration<Object> children() {
        return new FilteredEnumerationWrapper(super.children(), this.getPattern());
    }

    @Override
    public void add(MutableTreeNode o) {
        super.add(o);
        this.filter(this.getPattern());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteredEnumerationWrapper
    implements Enumeration<Object> {
        private final Enumeration<Object> enumeration;
        private final Pattern pattern;
        private Object next;

        private FilteredEnumerationWrapper(Enumeration<Object> enumeration, Pattern pattern) {
            this.enumeration = enumeration;
            this.pattern = pattern;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }

        @Override
        public Object nextElement() {
            if (this.next == null) {
                return this.enumeration.nextElement();
            }
            Object ret = this.next;
            this.next = null;
            while (this.enumeration.hasMoreElements()) {
                Object tmp = this.enumeration.nextElement();
                if (!this.pattern.matcher(tmp.toString()).find()) continue;
                this.next = tmp;
                break;
            }
            return ret;
        }
    }
}

