/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.v1;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDataSetDss;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public final class FileInfoDssDownloader {
    private final IDataSetDss dataSetDss;
    private final FileInfoDssDTO[] fileInfos;
    private final File outputDir;
    private final FileInfoDssDownloaderListener listener;

    public FileInfoDssDownloader(IDataSetDss dataSetDss, FileInfoDssDTO[] fileInfos, File outputDir) {
        this(dataSetDss, fileInfos, outputDir, new FileInfoDssDownloaderListener(){

            public void willCreateDirectory(FileInfoDssDTO fileInfo) {
            }

            public void willDownload(FileInfoDssDTO fileInfo) {
            }

            public void didFinish() {
            }
        });
    }

    public FileInfoDssDownloader(IDataSetDss dataSetDss, FileInfoDssDTO[] fileInfos, File outputDir, FileInfoDssDownloaderListener listenerOrNull) {
        this.dataSetDss = dataSetDss;
        this.fileInfos = fileInfos;
        this.outputDir = outputDir;
        this.listener = listenerOrNull;
    }

    public final void downloadFiles() {
        FileInfoDssDTO[] fileInfoDssDTOArray = this.fileInfos;
        int n = this.fileInfos.length;
        int n2 = 0;
        while (n2 < n) {
            FileInfoDssDTO fileInfo = fileInfoDssDTOArray[n2];
            if (fileInfo.isDirectory()) {
                this.listener.willCreateDirectory(fileInfo);
                File dir = new File(this.outputDir, fileInfo.getPathInListing());
                dir.mkdirs();
            } else {
                this.listener.willDownload(fileInfo);
                File file = new File(this.outputDir, fileInfo.getPathInListing());
                file.getParentFile().mkdirs();
                this.downloadFile(fileInfo, file);
            }
            ++n2;
        }
        this.listener.didFinish();
    }

    private void downloadFile(FileInfoDssDTO fileInfo, File file) {
        FileOutputStream fos = null;
        InputStream is = null;
        try {
            try {
                fos = new FileOutputStream(file);
                is = this.dataSetDss.getFile(fileInfo.getPathInDataSet());
                IOUtils.copyLarge((InputStream)is, (OutputStream)fos);
            }
            catch (IOException e) {
                throw new IOExceptionUnchecked(e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
        IOUtils.closeQuietly((InputStream)is);
    }

    public static interface FileInfoDssDownloaderListener {
        public void willCreateDirectory(FileInfoDssDTO var1);

        public void willDownload(FileInfoDssDTO var1);

        public void didFinish();
    }
}

