/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.api.v1;

import ch.systemsx.cisd.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalFileInfoDssBuilder {
    private final IHierarchicalContentNode listingRootNode;

    public HierarchicalFileInfoDssBuilder(IHierarchicalContentNode listingRootNode) {
        this.listingRootNode = listingRootNode;
    }

    public void appendFileInfos(ArrayList<FileInfoDssDTO> list, boolean isRecursive) throws IOException {
        this.appendFileInfosForNode(this.listingRootNode, list, isRecursive ? Integer.MAX_VALUE : 0, true);
    }

    private void appendFileInfosForNode(IHierarchicalContentNode currentNode, ArrayList<FileInfoDssDTO> list, int maxDepth, boolean excludeTopLevelIfDirectory) throws IOException {
        FileInfoDssDTO fileInfo = this.fileInfoForNode(currentNode);
        if (!excludeTopLevelIfDirectory || !fileInfo.isDirectory()) {
            list.add(fileInfo);
        }
        if (!fileInfo.isDirectory() || maxDepth < 0) {
            return;
        }
        for (IHierarchicalContentNode childNode : currentNode.getChildNodes()) {
            this.appendFileInfosForNode(childNode, list, maxDepth - 1, false);
        }
    }

    private FileInfoDssDTO fileInfoForNode(IHierarchicalContentNode node) throws IOException {
        FileInfoDssDTO fileInfo = new FileInfoDssDTO(node.getRelativePath(), this.pathRelativeToListingRoot(node), node.isDirectory(), node.isDirectory() ? -1L : node.getFileLength());
        return fileInfo;
    }

    private String pathRelativeToListingRoot(IHierarchicalContentNode node) throws IOException {
        String path = node.getRelativePath();
        String listingRootNodeRelativePath = this.listingRootNode.getRelativePath();
        if ((path = path.substring(listingRootNodeRelativePath.length())).startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }
}

