/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ValidationError {
    private final ValidationErrorTarget target;
    private final String propertyCodeOrNull;
    private final String errorMessage;

    public static ValidationError createDataSetTypeValidationError(String errorMessage) {
        return new ValidationError(ValidationErrorTarget.DATA_SET_TYPE, null, errorMessage);
    }

    public static ValidationError createOwnerValidationError(String errorMessage) {
        return new ValidationError(ValidationErrorTarget.DATA_SET_OWNER, null, errorMessage);
    }

    public static ValidationError createPropertyValidationError(String propertyCode, String errorMessage) {
        return new ValidationError(ValidationErrorTarget.DATA_SET_PROPERTY, propertyCode, errorMessage);
    }

    public static ValidationError createFileValidationError(String errorMessage) {
        return new ValidationError(ValidationErrorTarget.DATA_SET_FILE, null, errorMessage);
    }

    private ValidationError(ValidationErrorTarget target, String propertyCodeOrNull, String errorMessage) {
        this.target = target;
        this.propertyCodeOrNull = propertyCodeOrNull;
        this.errorMessage = errorMessage;
    }

    public ValidationErrorTarget getTarget() {
        return this.target;
    }

    public String getPropertyCodeOrNull() {
        return this.propertyCodeOrNull;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append((Object)this.target);
        builder.append((Object)this.propertyCodeOrNull);
        builder.append((Object)this.errorMessage);
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValidationErrorTarget {
        DATA_SET_TYPE,
        DATA_SET_OWNER,
        DATA_SET_PROPERTY,
        DATA_SET_FILE;

    }
}

