/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.authorization.ISessionProvider;
import ch.systemsx.cisd.openbis.generic.shared.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DisplaySettings;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomColumn;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IServer
extends ISessionProvider {
    public static final int VERSION = 32;

    public int getVersion();

    @Transactional(readOnly=true)
    public boolean isArchivingConfigured(String var1);

    @Transactional
    public SessionContextDTO tryToAuthenticate(String var1, String var2);

    @Transactional
    public SessionContextDTO tryToAuthenticateAnonymously();

    public SessionContextDTO tryGetSession(String var1);

    @Transactional
    public void setBaseIndexURL(String var1, String var2);

    @Transactional
    public String getBaseIndexURL(String var1);

    @Transactional
    public DisplaySettings getDefaultDisplaySettings(String var1);

    @Transactional
    public void saveDisplaySettings(String var1, DisplaySettings var2, int var3);

    @Transactional
    public List<GridCustomColumn> listGridCustomColumns(String var1, String var2);

    @Transactional
    public void changeUserHomeSpace(String var1, TechId var2);

    public void logout(String var1) throws UserFailureException;

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void setSessionUser(String var1, String var2);
}

