/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFetchOptions;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityRegistrationDetails;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.InitializingChecks;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.codehaus.jackson.annotate.JsonIgnore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String code;
    private String experimentIdentifier;
    private String sampleIdentifierOrNull;
    private String dataSetTypeCode;
    private boolean containerDataSet;
    private HashMap<String, String> properties;
    private EnumSet<Connections> retrievedConnections;
    private List<String> parentCodes = Collections.emptyList();
    private List<String> childrenCodes = Collections.emptyList();
    private List<DataSet> containedDataSets = Collections.emptyList();
    private EntityRegistrationDetails registrationDetails;
    private DataSetFetchOptions fetchOptions;

    public DataSet(DataSetInitializer initializer) {
        InitializingChecks.checkValidString(initializer.getCode(), "Unspecified code.");
        this.code = initializer.getCode();
        this.experimentIdentifier = initializer.getExperimentIdentifier();
        this.sampleIdentifierOrNull = initializer.getSampleIdentifierOrNull();
        InitializingChecks.checkValidString(initializer.getDataSetTypeCode(), "Unspecified data set type code.");
        this.dataSetTypeCode = initializer.getDataSetTypeCode();
        this.properties = initializer.getProperties();
        this.retrievedConnections = initializer.getRetrievedConnections();
        this.parentCodes = initializer.getParentCodes();
        this.childrenCodes = initializer.getChildrenCodes();
        InitializingChecks.checkValidRegistrationDetails(initializer.getRegistrationDetails(), "Unspecified entity registration details.");
        this.registrationDetails = initializer.getRegistrationDetails();
        this.containerDataSet = initializer.isContainerDataSet();
        this.containedDataSets = initializer.getContainedDataSets();
    }

    public String getCode() {
        return this.code;
    }

    public String getExperimentIdentifier() {
        return this.experimentIdentifier;
    }

    public String getSampleIdentifierOrNull() {
        return this.sampleIdentifierOrNull;
    }

    public String getDataSetTypeCode() {
        return this.dataSetTypeCode;
    }

    @JsonIgnore
    public Date getRegistrationDate() {
        return this.getRegistrationDetails().getRegistrationDate();
    }

    public HashMap<String, String> getProperties() {
        return this.properties;
    }

    public EnumSet<Connections> getRetrievedConnections() {
        return this.retrievedConnections;
    }

    @JsonIgnore
    public List<String> getParentCodes() throws IllegalArgumentException {
        if (this.getRetrievedConnections().contains((Object)Connections.PARENTS)) {
            return Collections.unmodifiableList(this.parentCodes);
        }
        throw new IllegalArgumentException("Parent codes were not retrieved for data set " + this.getCode() + ".");
    }

    @JsonIgnore
    public List<String> getChildrenCodes() throws IllegalArgumentException {
        if (this.getRetrievedConnections().contains((Object)Connections.CHILDREN)) {
            return Collections.unmodifiableList(this.childrenCodes);
        }
        throw new IllegalArgumentException("Children codes were not retrieved for data set " + this.getCode() + ".");
    }

    public EntityRegistrationDetails getRegistrationDetails() {
        return this.registrationDetails;
    }

    public boolean isContainerDataSet() {
        return this.containerDataSet;
    }

    public List<DataSet> getContainedDataSets() {
        return this.containedDataSets;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DataSet)) {
            return false;
        }
        EqualsBuilder builder = new EqualsBuilder();
        DataSet other = (DataSet)obj;
        builder.append((Object)this.getCode(), (Object)other.getCode());
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        return builder.toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append((Object)this.getCode());
        builder.append((Object)this.getExperimentIdentifier());
        builder.append((Object)this.getSampleIdentifierOrNull());
        builder.append((Object)this.getDataSetTypeCode());
        TreeMap<String, String> sortedProps = new TreeMap<String, String>(this.getProperties());
        builder.append((Object)sortedProps.toString());
        if (this.retrievedConnections.contains((Object)Connections.PARENTS)) {
            builder.append(this.getParentCodes());
        }
        return builder.toString();
    }

    private DataSet() {
    }

    private void setCode(String code) {
        this.code = code;
    }

    private void setExperimentIdentifier(String experimentIdentifier) {
        this.experimentIdentifier = experimentIdentifier;
    }

    private void setSampleIdentifierOrNull(String sampleIdentifierOrNull) {
        this.sampleIdentifierOrNull = sampleIdentifierOrNull;
    }

    private void setDataSetTypeCode(String dataSetTypeCode) {
        this.dataSetTypeCode = dataSetTypeCode;
    }

    private void setProperties(HashMap<String, String> properties) {
        this.properties = properties;
    }

    private void setRetrievedConnections(EnumSet<Connections> retrievedConnections) {
        this.retrievedConnections = retrievedConnections;
    }

    private void setParentCodes(List<String> parentCodes) {
        this.parentCodes = parentCodes;
    }

    private void setRegistrationDetails(EntityRegistrationDetails registrationDetails) {
        this.registrationDetails = registrationDetails;
    }

    public void setContainerDataSet(boolean containerDataSet) {
        this.containerDataSet = containerDataSet;
    }

    public void setContainedDataSets(List<DataSet> containedDataSets) {
        this.containedDataSets = containedDataSets;
    }

    public DataSetFetchOptions getFetchOptions() {
        return this.fetchOptions;
    }

    public void setFetchOptions(DataSetFetchOptions fetchOptions) {
        this.fetchOptions = fetchOptions;
        if (fetchOptions != null) {
            if (fetchOptions.isSupersetOf(new DataSetFetchOption[]{DataSetFetchOption.PARENTS, DataSetFetchOption.CHILDREN})) {
                this.setRetrievedConnections(EnumSet.of(Connections.PARENTS, Connections.CHILDREN));
            } else if (fetchOptions.isSupersetOf(new DataSetFetchOption[]{DataSetFetchOption.PARENTS})) {
                this.setRetrievedConnections(EnumSet.of(Connections.PARENTS));
            } else if (fetchOptions.isSupersetOf(new DataSetFetchOption[]{DataSetFetchOption.CHILDREN})) {
                this.setRetrievedConnections(EnumSet.of(Connections.CHILDREN));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Connections {
        PARENTS,
        CHILDREN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DataSetInitializer {
        private String code;
        private String sampleIdentifierOrNull;
        private String experimentIdentifier;
        private String dataSetTypeCode;
        private boolean containerDataSet;
        private EnumSet<Connections> retrievedConnections = EnumSet.noneOf(Connections.class);
        private List<String> parentCodes = Collections.emptyList();
        private List<String> childrenCodes = Collections.emptyList();
        private List<DataSet> containedDataSets = Collections.emptyList();
        private HashMap<String, String> properties = new HashMap();
        private EntityRegistrationDetails registrationDetails;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getSampleIdentifierOrNull() {
            return this.sampleIdentifierOrNull;
        }

        public void setSampleIdentifierOrNull(String sampleIdentifierOrNull) {
            this.sampleIdentifierOrNull = sampleIdentifierOrNull;
        }

        public String getExperimentIdentifier() {
            return this.experimentIdentifier;
        }

        public void setExperimentIdentifier(String experimentIdentifier) {
            this.experimentIdentifier = experimentIdentifier;
        }

        public void setDataSetTypeCode(String dataSetTypeCode) {
            this.dataSetTypeCode = dataSetTypeCode;
        }

        public String getDataSetTypeCode() {
            return this.dataSetTypeCode;
        }

        public HashMap<String, String> getProperties() {
            return this.properties;
        }

        public void putProperty(String propCode, String value) {
            this.properties.put(propCode, value);
        }

        public void setRetrievedConnections(EnumSet<Connections> retrievedConnections) {
            this.retrievedConnections = retrievedConnections == null ? EnumSet.noneOf(Connections.class) : retrievedConnections;
        }

        public EnumSet<Connections> getRetrievedConnections() {
            return this.retrievedConnections;
        }

        public void setParentCodes(List<String> parentCodes) {
            this.parentCodes = parentCodes == null ? new ArrayList() : parentCodes;
        }

        public List<String> getParentCodes() {
            return this.parentCodes;
        }

        public List<String> getChildrenCodes() {
            return this.childrenCodes;
        }

        public void setChildrenCodes(List<String> childrenCodes) {
            this.childrenCodes = childrenCodes == null ? new ArrayList() : childrenCodes;
        }

        public void setRegistrationDetails(EntityRegistrationDetails registrationDetails) {
            this.registrationDetails = registrationDetails;
        }

        public EntityRegistrationDetails getRegistrationDetails() {
            return this.registrationDetails;
        }

        public boolean isContainerDataSet() {
            return this.containerDataSet;
        }

        public void setContainerDataSet(boolean containerDataSet) {
            this.containerDataSet = containerDataSet;
        }

        public List<DataSet> getContainedDataSets() {
            return this.containedDataSets;
        }

        public void setContainedDataSets(List<DataSet> containedDataSets) {
            this.containedDataSets = containedDataSets == null ? new ArrayList() : containedDataSets;
        }
    }
}

