/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.InitializingChecks;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.PropertyTypeGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataSetType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String code;
    private ArrayList<PropertyTypeGroup> propertyTypeGroups;

    public DataSetType(DataSetTypeInitializer initializer) {
        InitializingChecks.checkValidString(initializer.getCode(), "Unspecified code.");
        this.code = initializer.getCode();
        this.propertyTypeGroups = initializer.getPropertyTypeGroups();
    }

    public String getCode() {
        return this.code;
    }

    public List<PropertyTypeGroup> getPropertyTypeGroups() {
        return this.propertyTypeGroups;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DataSetType)) {
            return false;
        }
        EqualsBuilder builder = new EqualsBuilder();
        DataSetType other = (DataSetType)obj;
        builder.append((Object)this.getCode(), (Object)other.getCode());
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        return builder.toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append((Object)this.getCode());
        builder.append(this.getPropertyTypeGroups());
        return builder.toString();
    }

    private DataSetType() {
    }

    private void setCode(String code) {
        this.code = code;
    }

    private void setPropertyTypeGroups(ArrayList<PropertyTypeGroup> propertyTypeGroups) {
        this.propertyTypeGroups = propertyTypeGroups;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DataSetTypeInitializer {
        private String code;
        private ArrayList<PropertyTypeGroup> propertyTypeGroups = new ArrayList();

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public ArrayList<PropertyTypeGroup> getPropertyTypeGroups() {
            return this.propertyTypeGroups;
        }

        public void addPropertyTypeGroup(PropertyTypeGroup propertyType) {
            this.propertyTypeGroups.add(propertyType);
        }
    }
}

