/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetTypeFilter {
    private final List<Pattern> whitelistPatterns;
    private final List<Pattern> blacklistPatterns;

    public static String convertPatternListToString(List<String> dataSetTypePatterns) {
        if (dataSetTypePatterns == null) {
            return "";
        }
        StringBuilder patternSb = new StringBuilder();
        for (String pattern : dataSetTypePatterns) {
            patternSb.append(pattern);
            patternSb.append(",");
        }
        if (patternSb.length() > 0) {
            patternSb.deleteCharAt(patternSb.length() - 1);
        }
        return patternSb.toString();
    }

    private static List<Pattern> convertPatternListStringToList(String patternListString) {
        String patternsString = patternListString == null ? "" : patternListString;
        String[] patterns = patternsString.split(",");
        ArrayList<Pattern> patternsList = new ArrayList<Pattern>();
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            String trimmedPattern = pattern.trim();
            if (trimmedPattern.length() > 0) {
                patternsList.add(Pattern.compile(trimmedPattern));
            }
            ++n2;
        }
        return patternsList;
    }

    public DataSetTypeFilter(String whitelistPatternString, String blacklistPatternString) {
        this.whitelistPatterns = DataSetTypeFilter.convertPatternListStringToList(whitelistPatternString);
        this.blacklistPatterns = DataSetTypeFilter.convertPatternListStringToList(blacklistPatternString);
    }

    public List<DataSetType> filterDataSetTypes(List<DataSetType> typesToFilter) {
        if (this.whitelistPatterns.size() > 0) {
            return this.filterUsingWhitelist(typesToFilter);
        }
        if (this.blacklistPatterns.size() > 0) {
            return this.filterUsingBlacklist(typesToFilter);
        }
        return typesToFilter;
    }

    private List<DataSetType> filterUsingWhitelist(List<DataSetType> typesToFilter) {
        ArrayList<DataSetType> filteredList = new ArrayList<DataSetType>();
        for (DataSetType type : typesToFilter) {
            this.ifMatchesAddToList(type, filteredList);
        }
        return filteredList;
    }

    private List<DataSetType> filterUsingBlacklist(List<DataSetType> typesToFilter) {
        ArrayList<DataSetType> filteredList = new ArrayList<DataSetType>();
        for (DataSetType type : typesToFilter) {
            this.ifNoMatchAddToList(type, filteredList);
        }
        return filteredList;
    }

    private void ifMatchesAddToList(DataSetType type, ArrayList<DataSetType> filteredList) {
        for (Pattern pattern : this.whitelistPatterns) {
            if (!pattern.matcher(type.getCode()).matches()) continue;
            filteredList.add(type);
            return;
        }
    }

    private void ifNoMatchAddToList(DataSetType type, ArrayList<DataSetType> filteredList) {
        for (Pattern pattern : this.blacklistPatterns) {
            if (!pattern.matcher(type.getCode()).matches()) continue;
            return;
        }
        filteredList.add(type);
    }
}

