/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchSubCriteria;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.codehaus.jackson.annotate.JsonSubTypes;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.annotate.JsonTypeName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchCriteria
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SearchOperator operator = SearchOperator.MATCH_ALL_CLAUSES;
    private ArrayList<MatchClause> matchClauses = new ArrayList();
    private ArrayList<SearchSubCriteria> subCriterias = new ArrayList();

    public void setOperator(SearchOperator operator) {
        this.operator = operator;
    }

    public SearchOperator getOperator() {
        return this.operator;
    }

    public List<MatchClause> getMatchClauses() {
        return Collections.unmodifiableList(this.matchClauses);
    }

    public void addMatchClause(MatchClause criterion) {
        this.matchClauses.add(criterion);
    }

    public List<SearchSubCriteria> getSubCriterias() {
        return Collections.unmodifiableList(this.subCriterias);
    }

    public void addSubCriteria(SearchSubCriteria criteria) {
        this.subCriterias.add(criteria);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchCriteria)) {
            return false;
        }
        SearchCriteria other = (SearchCriteria)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getOperator(), (Object)other.getOperator());
        builder.append(this.getMatchClauses(), other.getMatchClauses());
        builder.append(this.getSubCriterias(), other.getSubCriterias());
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getOperator());
        builder.append(this.getMatchClauses());
        builder.append(this.getSubCriterias());
        return builder.toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append((Object)this.getOperator());
        builder.append(this.getMatchClauses());
        builder.append(this.getSubCriterias());
        return builder.toString();
    }

    private void setMatchClauses(ArrayList<MatchClause> matchClauses) {
        this.matchClauses = matchClauses;
    }

    private void setSubCriterias(ArrayList<SearchSubCriteria> subCriterias) {
        this.subCriterias = subCriterias;
    }

    @JsonTypeName(value="AttributeMatchClause")
    public static class AttributeMatchClause
    extends MatchClause {
        private static final long serialVersionUID = 1L;
        private MatchClauseAttribute attribute;

        protected AttributeMatchClause(MatchClauseAttribute attribute, String desiredValue) {
            super(MatchClauseFieldType.ATTRIBUTE, attribute.toString(), desiredValue, CompareMode.EQUALS);
            this.attribute = attribute;
        }

        protected AttributeMatchClause(MatchClauseAttribute attribute, CompareMode mode, Date desiredValue) {
            super(MatchClauseFieldType.ATTRIBUTE, attribute.toString(), Long.toString(desiredValue.getTime()), mode);
            this.attribute = attribute;
        }

        public MatchClauseAttribute getAttribute() {
            return this.attribute;
        }

        private AttributeMatchClause() {
        }

        private void setAttribute(MatchClauseAttribute attribute) {
            this.attribute = attribute;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompareMode {
        LESS_THAN_OR_EQUAL,
        EQUALS,
        MORE_THAN_OR_EQUAL;

    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
    @JsonTypeName(value="MatchClause")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=AttributeMatchClause.class), @JsonSubTypes.Type(value=PropertyMatchClause.class)})
    public static class MatchClause
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private MatchClauseFieldType fieldType;
        private String fieldCode;
        private String desiredValue;
        private CompareMode compareMode = CompareMode.EQUALS;

        protected MatchClause(MatchClauseFieldType fieldType, String fieldCode, String desiredValue, CompareMode compareMode) {
            this.fieldType = fieldType;
            this.fieldCode = fieldCode;
            this.desiredValue = desiredValue;
            this.compareMode = compareMode;
        }

        public static MatchClause createPropertyMatch(String propertyCode, String desiredValue) {
            return new PropertyMatchClause(propertyCode, desiredValue);
        }

        public static MatchClause createAttributeMatch(MatchClauseAttribute attribute, String desiredValue) {
            return new AttributeMatchClause(attribute, desiredValue);
        }

        public static MatchClause createAttributeMatch(MatchClauseAttribute attribute, CompareMode mode, Date date) {
            return new AttributeMatchClause(attribute, mode, date);
        }

        public MatchClauseFieldType getFieldType() {
            return this.fieldType;
        }

        private String getFieldCode() {
            return this.fieldCode;
        }

        public String getDesiredValue() {
            return this.desiredValue;
        }

        public CompareMode getCompareMode() {
            if (this.compareMode == null) {
                return CompareMode.EQUALS;
            }
            return this.compareMode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MatchClause)) {
                return false;
            }
            MatchClause other = (MatchClause)obj;
            EqualsBuilder builder = new EqualsBuilder();
            builder.append((Object)this.getFieldType(), (Object)other.getFieldType());
            builder.append((Object)this.getFieldCode(), (Object)other.getFieldCode());
            builder.append((Object)this.getDesiredValue(), (Object)other.getDesiredValue());
            builder.append((Object)this.getCompareMode(), (Object)other.getCompareMode());
            return builder.isEquals();
        }

        public int hashCode() {
            HashCodeBuilder builder = new HashCodeBuilder();
            builder.append((Object)this.getFieldType());
            builder.append((Object)this.getFieldCode());
            builder.append((Object)this.getDesiredValue());
            builder.append((Object)this.getCompareMode());
            return builder.toHashCode();
        }

        public String toString() {
            ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
            builder.append((Object)this.getFieldType());
            builder.append((Object)this.getFieldCode());
            builder.append((Object)this.getDesiredValue());
            builder.append((Object)this.getCompareMode());
            return builder.toString();
        }

        private MatchClause() {
        }

        private void setFieldType(MatchClauseFieldType fieldType) {
            this.fieldType = fieldType;
        }

        private void setFieldCode(String fieldCode) {
            this.fieldCode = fieldCode;
        }

        private void setDesiredValue(String desiredValue) {
            this.desiredValue = desiredValue;
        }

        private void setCompareMode(CompareMode mode) {
            this.compareMode = mode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MatchClauseAttribute {
        CODE,
        TYPE,
        SPACE,
        PROJECT,
        REGISTRATION_DATE,
        MODIFICATION_DATE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MatchClauseFieldType {
        PROPERTY,
        ATTRIBUTE;

    }

    @JsonTypeName(value="PropertyMatchClause")
    public static class PropertyMatchClause
    extends MatchClause {
        private static final long serialVersionUID = 1L;
        private String propertyCode;

        protected PropertyMatchClause(String propertyCode, String desiredValue) {
            super(MatchClauseFieldType.PROPERTY, propertyCode, desiredValue, CompareMode.EQUALS);
            this.propertyCode = propertyCode;
            assert (propertyCode != null);
            assert (desiredValue != null);
        }

        public String getPropertyCode() {
            return this.propertyCode;
        }

        private PropertyMatchClause() {
        }

        private void setPropertyCode(String propertyCode) {
            this.propertyCode = propertyCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchOperator {
        MATCH_ALL_CLAUSES,
        MATCH_ANY_CLAUSES;

    }
}

