/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchableEntityKind;
import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class SearchSubCriteria
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SearchCriteria criteria;
    private SearchableEntityKind targetEntityKind;

    public static SearchSubCriteria createSampleParentCriteria(SearchCriteria criteria) {
        return new SearchSubCriteria(SearchableEntityKind.SAMPLE_PARENT, criteria);
    }

    public static SearchSubCriteria createSampleChildCriteria(SearchCriteria criteria) {
        return new SearchSubCriteria(SearchableEntityKind.SAMPLE_CHILD, criteria);
    }

    public static SearchSubCriteria createSampleContainerCriteria(SearchCriteria criteria) {
        return new SearchSubCriteria(SearchableEntityKind.SAMPLE_CONTAINER, criteria);
    }

    public static SearchSubCriteria createSampleCriteria(SearchCriteria criteria) {
        return new SearchSubCriteria(SearchableEntityKind.SAMPLE, criteria);
    }

    public static SearchSubCriteria createExperimentCriteria(SearchCriteria criteria) {
        return new SearchSubCriteria(SearchableEntityKind.EXPERIMENT, criteria);
    }

    public static SearchSubCriteria createDataSetContainerCriteria(SearchCriteria criteria) {
        return new SearchSubCriteria(SearchableEntityKind.DATA_SET_CONTAINER, criteria);
    }

    public static SearchSubCriteria createDataSetParentCriteria(SearchCriteria criteria) {
        return new SearchSubCriteria(SearchableEntityKind.DATA_SET_PARENT, criteria);
    }

    public static SearchSubCriteria createDataSetChildCriteria(SearchCriteria criteria) {
        return new SearchSubCriteria(SearchableEntityKind.DATA_SET_CHILD, criteria);
    }

    protected SearchSubCriteria(SearchableEntityKind targetEntityKind, SearchCriteria criteria) {
        this.targetEntityKind = targetEntityKind;
        this.criteria = criteria;
    }

    public SearchCriteria getCriteria() {
        return this.criteria;
    }

    public SearchableEntityKind getTargetEntityKind() {
        return this.targetEntityKind;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchCriteria.MatchClause)) {
            return false;
        }
        SearchSubCriteria other = (SearchSubCriteria)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getTargetEntityKind(), (Object)other.getTargetEntityKind());
        builder.append((Object)this.getCriteria(), (Object)other.getCriteria());
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getTargetEntityKind());
        builder.append((Object)this.getCriteria());
        return builder.toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append((Object)this.getTargetEntityKind());
        builder.append((Object)this.getCriteria());
        return builder.toString();
    }

    private SearchSubCriteria() {
    }

    private void setCriteria(SearchCriteria criteria) {
        this.criteria = criteria;
    }

    private void setTargetEntityKind(SearchableEntityKind targetEntityKind) {
        this.targetEntityKind = targetEntityKind;
    }
}

