/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.filter;

import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.filter.IDataSetFilter;

public class AndDataSetFilter
implements IDataSetFilter {
    private final IDataSetFilter[] dataSetFilters;

    public AndDataSetFilter(IDataSetFilter ... dataSetFilters) {
        this.dataSetFilters = dataSetFilters;
    }

    public boolean pass(DataSet dataSet) {
        IDataSetFilter[] iDataSetFilterArray = this.dataSetFilters;
        int n = this.dataSetFilters.length;
        int n2 = 0;
        while (n2 < n) {
            IDataSetFilter filter = iDataSetFilterArray[n2];
            if (!filter.pass(dataSet)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        IDataSetFilter[] iDataSetFilterArray = this.dataSetFilters;
        int n = this.dataSetFilters.length;
        int n2 = 0;
        while (n2 < n) {
            IDataSetFilter filter = iDataSetFilterArray[n2];
            if (builder.length() > 0) {
                builder.append(" AND ");
            }
            builder.append(filter);
            ++n2;
        }
        return builder.toString();
    }
}

