/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.filter;

import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.filter.IDataSetFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesBasedDataSetFilter
implements IDataSetFilter {
    private final Map<String, String> map;

    public PropertiesBasedDataSetFilter(Map<String, String> properties) {
        this.map = properties;
    }

    @Override
    public boolean pass(DataSet dataSet) {
        HashMap<String, String> properties = dataSet.getProperties();
        Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value.equals(properties.get(key))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
        ArrayList<Map.Entry<String, String>> sortedEntries = new ArrayList<Map.Entry<String, String>>(entrySet);
        Collections.sort(sortedEntries, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return "Properties:" + sortedEntries;
    }
}

