/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.shared.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.AbstractDatabaseInstancePredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSpacePredicate<T>
extends AbstractDatabaseInstancePredicate<T> {
    protected List<SpacePE> spaces;
    protected boolean okForNonExistentSpaces;

    protected AbstractSpacePredicate() {
        this(false);
    }

    protected AbstractSpacePredicate(boolean okForNonExistentSpaces) {
        this.okForNonExistentSpaces = okForNonExistentSpaces;
    }

    @Override
    public void init(IAuthorizationDataProvider provider) {
        super.init(provider);
        this.spaces = provider.listSpaces();
    }

    protected Status evaluate(PersonPE person, List<RoleWithIdentifier> allowedRoles, DatabaseInstancePE databaseInstance, String spaceCodeOrNull) {
        String databaseInstanceUUID = databaseInstance.getUuid();
        return this.evaluate(person, allowedRoles, databaseInstanceUUID, databaseInstance.getCode(), spaceCodeOrNull);
    }

    protected Status evaluate(PersonPE person, List<RoleWithIdentifier> allowedRoles, String databaseInstanceUUID, String databaseInstanceCode, String spaceCodeOrNull) {
        if (this.tryFindSpace(databaseInstanceUUID, spaceCodeOrNull) == null) {
            if (this.okForNonExistentSpaces) {
                return Status.OK;
            }
            return this.createError(person, spaceCodeOrNull);
        }
        boolean matching = this.isMatching(allowedRoles, databaseInstanceUUID, spaceCodeOrNull);
        if (matching) {
            return Status.OK;
        }
        return this.createError(person, spaceCodeOrNull);
    }

    private Status createError(PersonPE person, String spaceCodeOrNull) {
        return Status.createError(String.format("User '%s' does not have enough privileges.", person.getUserId(), spaceCodeOrNull));
    }

    private SpacePE tryFindSpace(String databaseInstanceUUID, String spaceCode) {
        for (SpacePE space : this.spaces) {
            if (!this.equalIdentifier(space, databaseInstanceUUID, spaceCode)) continue;
            return space;
        }
        return null;
    }

    private boolean isMatching(List<RoleWithIdentifier> allowedRoles, String databaseInstanceUUID, String spaceCodeOrNull) {
        for (RoleWithIdentifier role : allowedRoles) {
            RoleWithHierarchy.RoleLevel roleLevel = role.getRoleLevel();
            if (roleLevel.equals(RoleWithHierarchy.RoleLevel.SPACE) && this.equalIdentifier(role.getAssignedSpace(), databaseInstanceUUID, spaceCodeOrNull)) {
                return true;
            }
            if (!roleLevel.equals(RoleWithHierarchy.RoleLevel.INSTANCE) || !role.getAssignedDatabaseInstance().getUuid().equals(databaseInstanceUUID)) continue;
            return true;
        }
        return false;
    }

    private boolean equalIdentifier(SpacePE space, String databaseInstanceUUID, String spaceCodeOrNull) {
        return (spaceCodeOrNull == null || space.getCode().equals(spaceCodeOrNull)) && space.getDatabaseInstance().getUuid().equals(databaseInstanceUUID);
    }
}

