/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.shared.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ShouldFlattenCollections(value=false)
public class DataSetCodeCollectionPredicate
extends AbstractSpacePredicate<List<String>> {
    @Override
    public String getCandidateDescription() {
        return "data set code";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, List<String> dataSetCodes) {
        assert (this.initialized) : "Predicate has not been initialized";
        Set<DataSetAccessPE> accessData = this.authorizationDataProvider.getDatasetCollectionAccessData(dataSetCodes);
        for (DataSetAccessPE accessDatum : accessData) {
            String spaceCode;
            String dbInstanceCode;
            String dbInstanceUUID = accessDatum.getDatabaseInstanceUuid();
            Status result = this.evaluate(person, allowedRoles, dbInstanceUUID, dbInstanceCode = accessDatum.getDatabaseInstanceCode(), spaceCode = accessDatum.getSpaceCode());
            if (result == Status.OK) continue;
            return result;
        }
        return Status.OK;
    }
}

