/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.shared.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetCodePredicate
extends AbstractSpacePredicate<String> {
    @Override
    public String getCandidateDescription() {
        return "data set code";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, String dataSetCode) {
        assert (this.initialized) : "Predicate has not been initialized";
        DataSetAccessPE accessData = this.authorizationDataProvider.tryGetDatasetAccessData(dataSetCode);
        if (accessData != null) {
            String dbInstanceUUID = accessData.getDatabaseInstanceUuid();
            String dbInstanceCode = accessData.getDatabaseInstanceCode();
            String groupCode = accessData.getSpaceCode();
            Status result = this.evaluate(person, allowedRoles, dbInstanceUUID, dbInstanceCode, groupCode);
            return result;
        }
        return Status.OK;
    }
}

