/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.shared.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.IPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DelegatedPredicate<P, T>
extends AbstractPredicate<T> {
    private final IPredicate<P> delegate;
    protected IAuthorizationDataProvider authorizationDataProvider;

    public DelegatedPredicate(IPredicate<P> delegate) {
        this.delegate = delegate;
    }

    public abstract P tryConvert(T var1);

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        this.authorizationDataProvider = provider;
        this.delegate.init(provider);
    }

    @Override
    public final Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, T value) {
        P convertedValue = this.tryConvert(value);
        if (convertedValue != null) {
            return this.delegate.evaluate(person, allowedRoles, convertedValue);
        }
        return Status.OK;
    }
}

