/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.shared.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.AbstractTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.SpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExperimentUpdatesPredicate
extends AbstractPredicate<ExperimentUpdatesDTO> {
    private final AbstractTechIdPredicate.ExperimentTechIdPredicate experimentTechIdPredicate = new AbstractTechIdPredicate.ExperimentTechIdPredicate();
    private final SpaceIdentifierPredicate spacePredicate = new SpaceIdentifierPredicate();

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        this.experimentTechIdPredicate.init(provider);
        this.spacePredicate.init(provider);
    }

    @Override
    public final String getCandidateDescription() {
        return "experiment updates";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, ExperimentUpdatesDTO updates) {
        assert (this.experimentTechIdPredicate.initialized) : "Predicate has not been initialized";
        Status status = this.experimentTechIdPredicate.doEvaluation(person, allowedRoles, updates.getExperimentId());
        if (!status.equals(Status.OK)) {
            return status;
        }
        status = this.spacePredicate.doEvaluation(person, allowedRoles, updates.getProjectIdentifier());
        return status;
    }
}

