/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.shared.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.DataSetCodeCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewDataSetsWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ShouldFlattenCollections(value=false)
public class NewDataSetsWithTypePredicate
extends AbstractPredicate<NewDataSetsWithTypes> {
    private final DataSetCodeCollectionPredicate dataSetCodeCollectionPredicate = new DataSetCodeCollectionPredicate();

    @Override
    public String getCandidateDescription() {
        return "data set code";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, NewDataSetsWithTypes dataSets) {
        ArrayList<String> codes = new ArrayList<String>();
        for (NewDataSet ds : dataSets.getNewDataSets()) {
            codes.add(ds.getCode());
        }
        return this.dataSetCodeCollectionPredicate.doEvaluation(person, allowedRoles, (List<String>)codes);
    }

    @Override
    public void init(IAuthorizationDataProvider provider) {
        this.dataSetCodeCollectionPredicate.init(provider);
    }
}

