/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.shared.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.AbstractTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.SpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.GroupIdentifier;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectUpdatesPredicate
extends AbstractPredicate<ProjectUpdatesDTO> {
    private final SpaceIdentifierPredicate spacePredicate = new SpaceIdentifierPredicate();
    private final AbstractTechIdPredicate.ProjectTechIdPredicate projectTechIdPredicate = new AbstractTechIdPredicate.ProjectTechIdPredicate();

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        this.spacePredicate.init(provider);
        this.projectTechIdPredicate.init(provider);
    }

    @Override
    public final String getCandidateDescription() {
        return "project updates";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, ProjectUpdatesDTO updates) {
        assert (this.spacePredicate.initialized) : "Predicate has not been initialized";
        assert (this.projectTechIdPredicate.initialized) : "Predicate has not been initialized";
        Status status = this.projectTechIdPredicate.doEvaluation(person, allowedRoles, updates.getTechId());
        if (!status.equals(Status.OK)) {
            return status;
        }
        String newGroupCode = updates.getGroupCode();
        if (newGroupCode != null) {
            GroupIdentifier newGroupIdentifier = new GroupIdentifier(DatabaseInstanceIdentifier.HOME, newGroupCode);
            status = this.spacePredicate.doEvaluation(person, allowedRoles, newGroupIdentifier);
        }
        return status;
    }
}

