/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.shared.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.AbstractDatabaseInstancePredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.SampleOwnerIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleTechIdPredicate
extends AbstractDatabaseInstancePredicate<TechId> {
    private final SampleOwnerIdentifierPredicate sampleOwnerIdentifierPredicate;

    public SampleTechIdPredicate() {
        this(true);
    }

    public SampleTechIdPredicate(boolean isReadAccess) {
        this.sampleOwnerIdentifierPredicate = new SampleOwnerIdentifierPredicate(isReadAccess);
    }

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        super.init(provider);
        this.sampleOwnerIdentifierPredicate.init(provider);
    }

    @Override
    public final String getCandidateDescription() {
        return "sample technical id";
    }

    @Override
    protected final Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, TechId techId) {
        SamplePE sample = this.authorizationDataProvider.getSample(techId);
        return this.sampleOwnerIdentifierPredicate.doEvaluation(person, allowedRoles, sample.getSampleIdentifier());
    }
}

