/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.shared.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.util.SpaceCodeHelper;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ShouldFlattenCollections
public class SpaceIdentifierPredicate
extends AbstractSpacePredicate<SpaceIdentifier> {
    public SpaceIdentifierPredicate() {
    }

    public SpaceIdentifierPredicate(boolean okForNonExistentSpaces) {
        super(okForNonExistentSpaces);
    }

    @Override
    public final String getCandidateDescription() {
        return "space identifier";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, SpaceIdentifier spaceIdentifier) {
        assert (this.initialized) : "Predicate has not been initialized";
        String spaceCode = SpaceCodeHelper.getSpaceCode(person, spaceIdentifier);
        DatabaseInstancePE databaseInstance = this.getDatabaseInstance(spaceIdentifier);
        return this.evaluate(person, allowedRoles, databaseInstance, spaceCode);
    }
}

