/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.authorization.validator;

import ch.systemsx.cisd.openbis.generic.shared.authorization.validator.AbstractValidator;
import ch.systemsx.cisd.openbis.generic.shared.authorization.validator.IValidator;
import ch.systemsx.cisd.openbis.generic.shared.authorization.validator.SimpleSpaceValidator;
import ch.systemsx.cisd.openbis.generic.shared.basic.ICodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractIdentifierValidator
extends AbstractValidator<IIdentifierHolder> {
    private final IValidator<ICodeHolder> spaceValidator = new SimpleSpaceValidator();

    AbstractIdentifierValidator() {
    }

    @Override
    public boolean doValidation(PersonPE person, IIdentifierHolder value) {
        final String spaceCodeOrNull = this.extractSpaceCodeOrNull(value.getIdentifier());
        return this.spaceValidator.isValid(person, new ICodeHolder(){

            public String getCode() {
                return spaceCodeOrNull;
            }
        });
    }

    protected abstract String extractSpaceCodeOrNull(String var1);
}

