/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic;

import ch.systemsx.cisd.openbis.generic.shared.basic.PrimitiveValue;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridRowModel<T>
implements IsSerializable,
Serializable {
    private static final long serialVersionUID = 1L;
    private T originalObject;
    private Map<String, PrimitiveValue> calculatedColumnValues;

    public static <T> GridRowModel<T> createWithoutCustomColumns(T originalObject) {
        return new GridRowModel<T>(originalObject, new HashMap<String, PrimitiveValue>());
    }

    public GridRowModel(T originalObject, Map<String, PrimitiveValue> calculatedColumnMap) {
        this.originalObject = originalObject;
        this.calculatedColumnValues = calculatedColumnMap;
    }

    public T getOriginalObject() {
        return this.originalObject;
    }

    public Map<String, PrimitiveValue> getCalculatedColumnValues() {
        return this.calculatedColumnValues;
    }

    public PrimitiveValue findColumnValue(String columnId) {
        PrimitiveValue valueOrNull = this.calculatedColumnValues.get(columnId);
        if (valueOrNull != null) {
            return valueOrNull;
        }
        throw new IllegalStateException("Column not found: " + columnId);
    }

    private GridRowModel() {
    }

    public String toString() {
        return "GridRowModel [originalObject=" + this.originalObject + ", calculatedColumnValues=" + this.calculatedColumnValues + "]";
    }
}

