/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;

public abstract class AbstractEntityProperty
implements IEntityProperty {
    private static final long serialVersionUID = 32L;
    private PropertyType propertyType;
    private Long ordinal;
    private boolean scriptable;

    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(PropertyType propertyType) {
        this.propertyType = propertyType;
    }

    public String tryGetAsString() {
        if (this.propertyType == null) {
            return null;
        }
        DataType dataType = this.propertyType.getDataType();
        if (dataType == null) {
            return this.getValue();
        }
        switch (dataType.getCode()) {
            case CONTROLLEDVOCABULARY: {
                VocabularyTerm vocabularyTerm = this.getVocabularyTerm();
                return vocabularyTerm != null ? vocabularyTerm.getCode() : this.getValue();
            }
            case MATERIAL: {
                Material material = this.getMaterial();
                return material != null ? MaterialIdentifier.print(material.getCode(), material.getMaterialType().getCode()) : this.getValue();
            }
        }
        return this.getValue();
    }

    public String tryGetOriginalValue() {
        return this.tryGetAsString();
    }

    public String getValue() {
        return null;
    }

    public void setValue(String value) {
    }

    public Material getMaterial() {
        return null;
    }

    public void setMaterial(Material material) {
    }

    public VocabularyTerm getVocabularyTerm() {
        return null;
    }

    public void setVocabularyTerm(VocabularyTerm vocabularyTerm) {
    }

    public void setOrdinal(Long ordinal) {
        this.ordinal = ordinal;
    }

    public Long getOrdinal() {
        return this.ordinal;
    }

    public boolean isManaged() {
        return false;
    }

    public void setScriptable(boolean scriptable) {
        this.scriptable = scriptable;
    }

    public boolean isScriptable() {
        return this.scriptable;
    }

    public String toString() {
        return this.propertyType + ": " + this.tryGetAsString();
    }

    public int compareTo(IEntityProperty o) {
        Long thisOrdinal = this.getOrdinal();
        Long otherOrdinal = o.getOrdinal();
        if (thisOrdinal != null && otherOrdinal != null) {
            return thisOrdinal.compareTo(otherOrdinal);
        }
        PropertyType thisPropertyType = this.getPropertyType();
        PropertyType otherPropertyType = o.getPropertyType();
        if (thisPropertyType.getLabel().equals(otherPropertyType.getLabel())) {
            return thisPropertyType.getCode().compareTo(otherPropertyType.getCode());
        }
        return thisPropertyType.getLabel().compareTo(otherPropertyType.getLabel());
    }
}

