/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.IReportInformationProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStoreServiceKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ReportingPluginType;
import java.io.Serializable;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatastoreServiceDescription
implements IReportInformationProvider,
Serializable,
Comparable<DatastoreServiceDescription> {
    private static final long serialVersionUID = 32L;
    private String key;
    private String label;
    private String[] datasetTypeCodes;
    private String datastoreCode;
    private String downloadURL;
    private DataStoreServiceKind serviceKind;
    private ReportingPluginType reportingPluginTypeOrNull;

    private DatastoreServiceDescription() {
    }

    public static DatastoreServiceDescription processing(String key, String label, String[] datasetTypeCodes, String datastoreCode) {
        return new DatastoreServiceDescription(key, label, datasetTypeCodes, datastoreCode, DataStoreServiceKind.PROCESSING);
    }

    public static DatastoreServiceDescription reporting(String key, String label, String[] datasetTypeCodes, String datastoreCode, ReportingPluginType type) {
        return new DatastoreServiceDescription(key, label, datasetTypeCodes, datastoreCode, DataStoreServiceKind.QUERIES, type);
    }

    @Deprecated
    public DatastoreServiceDescription(String key, String label, String[] datasetTypeCodes, String datastoreCode, DataStoreServiceKind serviceKind) {
        this(key, label, datasetTypeCodes, datastoreCode, serviceKind, null);
    }

    private DatastoreServiceDescription(String key, String label, String[] datasetTypeCodes, String datastoreCode, DataStoreServiceKind serviceKind, ReportingPluginType reportingPluginTypeOrNull) {
        this.key = key;
        this.label = label;
        this.datasetTypeCodes = datasetTypeCodes;
        this.datastoreCode = datastoreCode;
        this.serviceKind = serviceKind;
        this.reportingPluginTypeOrNull = reportingPluginTypeOrNull;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public DataStoreServiceKind getServiceKind() {
        return this.serviceKind;
    }

    public String[] getDatasetTypeCodes() {
        return this.datasetTypeCodes;
    }

    public String getDatastoreCode() {
        return this.datastoreCode;
    }

    @Override
    public String getDownloadURL() {
        return this.downloadURL;
    }

    public void setDownloadURL(String downloadURL) {
        this.downloadURL = downloadURL;
    }

    public ReportingPluginType tryReportingPluginType() {
        return this.reportingPluginTypeOrNull;
    }

    public void setReportingPluginTypeOrNull(ReportingPluginType reportingPluginTypeOrNull) {
        this.reportingPluginTypeOrNull = reportingPluginTypeOrNull;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.getServiceKind());
        sb.append("; ");
        sb.append(this.getKey());
        sb.append("; ");
        sb.append(this.getDatastoreCode());
        sb.append("; ");
        sb.append(this.getLabel());
        sb.append("; ");
        String[] stringArray = this.getDatasetTypeCodes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String code = stringArray[n2];
            sb.append(code);
            sb.append(" ");
            ++n2;
        }
        sb.append("; ");
        sb.append(this.reportingPluginTypeOrNull);
        sb.append("]");
        return sb.toString();
    }

    public static boolean isMatching(DatastoreServiceDescription service, ExternalData dataset) {
        return service.getDatastoreCode().equals(dataset.getDataStore().getCode()) && Arrays.asList(service.getDatasetTypeCodes()).contains(dataset.getDataSetType().getCode());
    }

    @Override
    public int compareTo(DatastoreServiceDescription o) {
        return this.getLabel().compareTo(o.getLabel());
    }
}

