/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.URLMethodWithParameters;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import java.util.HashMap;
import java.util.Map;

public class GeneratedImageTableCell
implements ISerializableComparable {
    public static final String IMAGE_WIDTH_PARAM = "w";
    public static final String IMAGE_HEIGHT_PARAM = "h";
    private static final long serialVersionUID = 32L;
    private String path;
    private int imageWidth;
    private int imageHeight;
    private int thumbnailWidth;
    private int thumbnailHeight;
    private HashMap<String, Object> parameters;

    public GeneratedImageTableCell(String path, int imageWidth, int imageHeight, int thumbnailWidth, int thumbnailHeight) {
        this.path = path;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.thumbnailWidth = thumbnailWidth;
        this.thumbnailHeight = thumbnailHeight;
        this.parameters = new HashMap();
    }

    private GeneratedImageTableCell() {
    }

    public String getPath() {
        return this.path;
    }

    int getImageWidth() {
        return this.imageWidth;
    }

    int getImageHeight() {
        return this.imageHeight;
    }

    public int getMaxThumbnailWidth() {
        return this.thumbnailWidth;
    }

    public int getMaxThumbnailHeight() {
        return this.thumbnailHeight;
    }

    public void addParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public int compareTo(ISerializableComparable o) {
        return this.toString().compareTo(String.valueOf(o));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GeneratedImageTableCell)) {
            return false;
        }
        GeneratedImageTableCell other = (GeneratedImageTableCell)obj;
        return other.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getHTMLString("url/", "sessionToken");
    }

    public String getHTMLString(String downloadURL, String sessionID) {
        String urlRoot = String.valueOf(downloadURL) + "/" + this.path;
        URLMethodWithParameters urlMethodImage = new URLMethodWithParameters(urlRoot);
        URLMethodWithParameters urlMethodThumb = new URLMethodWithParameters(urlRoot);
        urlMethodImage.addParameter("sessionID", sessionID);
        urlMethodThumb.addParameter("sessionID", sessionID);
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            urlMethodImage.addParameter(entry.getKey(), entry.getValue());
            urlMethodThumb.addParameter(entry.getKey(), entry.getValue());
        }
        urlMethodImage.addParameter(IMAGE_WIDTH_PARAM, this.imageWidth);
        urlMethodImage.addParameter(IMAGE_HEIGHT_PARAM, this.imageHeight);
        urlMethodThumb.addParameter(IMAGE_WIDTH_PARAM, this.thumbnailWidth);
        urlMethodThumb.addParameter(IMAGE_HEIGHT_PARAM, this.thumbnailHeight);
        return URLMethodWithParameters.createEmbededImageHtml(urlMethodThumb.toString(), urlMethodImage.toString(), this.thumbnailWidth, this.thumbnailHeight);
    }
}

