/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TrackingSampleCriteria;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListOrSearchSampleCriteria
extends ListSampleCriteria {
    private static final long serialVersionUID = 32L;
    private ListSampleCriteria listCriteria;
    private TrackingSampleCriteria newTrackingCriteria;
    private Collection<Long> sampleIds;
    private final String[] sampleCodes;
    private final String[] permIds;
    private final boolean searchForContainerSamplesOnly;
    private boolean enrichDependentSamplesWithProperties = false;

    public ListOrSearchSampleCriteria(ListSampleCriteria listCriteria) {
        assert (listCriteria != null);
        this.listCriteria = listCriteria;
        this.sampleCodes = null;
        this.permIds = null;
        this.searchForContainerSamplesOnly = false;
    }

    public ListOrSearchSampleCriteria(TrackingSampleCriteria newTrackingCriteria) {
        assert (newTrackingCriteria != null);
        this.newTrackingCriteria = newTrackingCriteria;
        this.sampleCodes = null;
        this.permIds = null;
        this.searchForContainerSamplesOnly = false;
    }

    public ListOrSearchSampleCriteria(Collection<Long> sampleIds) {
        assert (sampleIds != null);
        this.sampleIds = sampleIds;
        this.sampleCodes = null;
        this.permIds = null;
        this.searchForContainerSamplesOnly = false;
    }

    public ListOrSearchSampleCriteria(String[] codes, boolean codesArePermIds) {
        this(codes, codesArePermIds, false);
    }

    public ListOrSearchSampleCriteria(String[] codes, boolean codesArePermIds, boolean searchForContainerSamplesOnly) {
        assert (codes != null);
        this.searchForContainerSamplesOnly = searchForContainerSamplesOnly;
        if (codesArePermIds) {
            this.sampleCodes = null;
            this.permIds = codes;
        } else {
            this.sampleCodes = codes;
            this.permIds = null;
        }
    }

    public ListOrSearchSampleCriteria(String[] codes, String[] permIds) {
        assert (codes != null);
        assert (permIds != null);
        this.sampleCodes = codes;
        this.permIds = permIds;
        this.searchForContainerSamplesOnly = false;
    }

    public Collection<Long> getSampleIds() {
        return this.sampleIds;
    }

    public String[] trySampleCodes() {
        return this.sampleCodes;
    }

    public String[] trySamplePermIds() {
        return this.permIds;
    }

    public String getSampleTypeCode() {
        return this.newTrackingCriteria == null ? null : this.newTrackingCriteria.getSampleTypeCode();
    }

    public String getPropertyTypeCode() {
        return this.newTrackingCriteria == null ? null : this.newTrackingCriteria.getPropertyTypeCode();
    }

    public String getPropertyValue() {
        return this.newTrackingCriteria == null ? null : this.newTrackingCriteria.getPropertyValue();
    }

    public Collection<Long> getAlreadyTrackedSampleIds() {
        return this.newTrackingCriteria == null ? null : this.newTrackingCriteria.getAlreadyTrackedSampleIds();
    }

    @Override
    public Collection<Long> getContainerSampleIds() {
        return this.listCriteria == null ? null : this.listCriteria.getContainerSampleIds();
    }

    @Override
    public TechId getParentSampleId() {
        return this.listCriteria == null ? null : this.listCriteria.getParentSampleId();
    }

    @Override
    public TechId getChildSampleId() {
        return this.listCriteria == null ? null : this.listCriteria.getChildSampleId();
    }

    @Override
    public boolean isOnlyDirectlyConnected() {
        return this.listCriteria == null ? super.isOnlyDirectlyConnected() : this.listCriteria.isOnlyDirectlyConnected();
    }

    @Override
    public Collection<Long> getChildrenSampleIds() {
        if (this.listCriteria == null) {
            return Collections.emptySet();
        }
        Collection<Long> childrenSampleIds = this.listCriteria.getChildrenSampleIds();
        if (childrenSampleIds != null) {
            return childrenSampleIds;
        }
        TechId childSampleId = this.listCriteria.getChildSampleId();
        if (childSampleId == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(childSampleId.getId());
    }

    @Override
    public TechId getExperimentId() {
        return this.listCriteria == null ? null : this.listCriteria.getExperimentId();
    }

    @Override
    public String getSpaceCode() {
        return this.listCriteria == null ? null : this.listCriteria.getSpaceCode();
    }

    @Override
    public SampleType getSampleType() {
        return this.listCriteria == null ? null : this.listCriteria.getSampleType();
    }

    @Override
    public boolean isExcludeWithoutExperiment() {
        return this.listCriteria == null ? false : this.listCriteria.isExcludeWithoutExperiment();
    }

    @Override
    public boolean isIncludeSpace() {
        return this.listCriteria == null ? false : this.listCriteria.isIncludeSpace();
    }

    @Override
    public boolean isIncludeInstance() {
        return this.listCriteria == null ? false : this.listCriteria.isIncludeInstance();
    }

    public boolean isEnrichDependentSamplesWithProperties() {
        return this.enrichDependentSamplesWithProperties;
    }

    public void setEnrichDependentSamplesWithProperties(boolean enrichDependentSamplesWithProperties) {
        this.enrichDependentSamplesWithProperties = enrichDependentSamplesWithProperties;
    }

    public boolean isSearchForContainerSamplesOnly() {
        return this.searchForContainerSamplesOnly;
    }
}

