/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListSampleCriteria
implements Serializable {
    private static final long serialVersionUID = 32L;
    private SampleType sampleType;
    private String spaceCode;
    private boolean includeSpace;
    private boolean includeInstance;
    private boolean excludeWithoutExperiment;
    private Collection<Long> containerSampleIds;
    private TechId parentSampleId;
    private TechId childSampleId;
    private TechId experimentId;
    private boolean onlyDirectlyConnected = true;
    private Collection<Long> childrenSampleIds;

    public static ListSampleCriteria createForContainer(TechId containerSampleId) {
        return ListSampleCriteria.createForContainers(Arrays.asList(containerSampleId.getId()));
    }

    public static ListSampleCriteria createForContainers(Collection<Long> containerSampleIds) {
        ListSampleCriteria criteria = new ListSampleCriteria();
        criteria.setContainerIds(containerSampleIds);
        return criteria;
    }

    public static ListSampleCriteria createForParent(TechId parentSampleId) {
        ListSampleCriteria criteria = new ListSampleCriteria();
        criteria.setParentId(parentSampleId);
        return criteria;
    }

    public static ListSampleCriteria createForChild(TechId childSampleId) {
        ListSampleCriteria criteria = new ListSampleCriteria();
        criteria.setChildId(childSampleId);
        return criteria;
    }

    public static ListSampleCriteria createForChildren(Collection<Long> childrenSampleIds) {
        ListSampleCriteria criteria = new ListSampleCriteria();
        criteria.setChildrenSampleIds(childrenSampleIds);
        return criteria;
    }

    public static ListSampleCriteria createForExperiment(TechId experimentId) {
        ListSampleCriteria criteria = new ListSampleCriteria();
        criteria.setExperimentId(experimentId);
        return criteria;
    }

    public Collection<Long> getContainerSampleIds() {
        return this.containerSampleIds;
    }

    private final void setContainerIds(Collection<Long> containerSampleIds) {
        this.containerSampleIds = containerSampleIds;
    }

    public TechId getParentSampleId() {
        return this.parentSampleId;
    }

    private final void setParentId(TechId parentSampleId) {
        this.parentSampleId = parentSampleId;
    }

    public TechId getChildSampleId() {
        return this.childSampleId;
    }

    private final void setChildId(TechId childSampleId) {
        this.childSampleId = childSampleId;
    }

    public Collection<Long> getChildrenSampleIds() {
        return this.childrenSampleIds;
    }

    public final void setChildrenSampleIds(Collection<Long> childrenSampleIds) {
        this.childrenSampleIds = childrenSampleIds;
    }

    public SampleType getSampleType() {
        return this.sampleType;
    }

    public void setSampleType(SampleType sampleType) {
        this.sampleType = sampleType;
    }

    public String getSpaceCode() {
        return this.spaceCode;
    }

    public void setSpaceCode(String spaceCode) {
        this.spaceCode = spaceCode;
    }

    public boolean isIncludeSpace() {
        return this.includeSpace;
    }

    public void setIncludeSpace(boolean includeSpace) {
        this.includeSpace = includeSpace;
    }

    public boolean isIncludeInstance() {
        return this.includeInstance;
    }

    public void setIncludeInstance(boolean includeInstance) {
        this.includeInstance = includeInstance;
    }

    public boolean isExcludeWithoutExperiment() {
        return this.excludeWithoutExperiment;
    }

    public void setExcludeWithoutExperiment(boolean excludeWithoutExperiment) {
        this.excludeWithoutExperiment = excludeWithoutExperiment;
    }

    public TechId getExperimentId() {
        return this.experimentId;
    }

    private void setExperimentId(TechId experimentId) {
        this.experimentId = experimentId;
    }

    public boolean isOnlyDirectlyConnected() {
        return this.onlyDirectlyConnected;
    }

    public void setOnlyDirectlyConnected(boolean onlyDirectlyConnected) {
        this.onlyDirectlyConnected = onlyDirectlyConnected;
    }
}

