/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.coreplugin;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CorePlugin;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.ICorePluginResourceLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorePluginScanner
implements ICorePluginResourceLoader {
    private static final ISimpleLogger DEFAULT_LOGGER = new Log4jSimpleLogger(LogFactory.getLogger(LogCategory.OPERATION, CorePluginScanner.class));
    private final ISimpleLogger log;
    private final File pluginsFolder;
    private final ScannerType scannerType;

    public CorePluginScanner(String pluginsFolderName, ScannerType scannerType) {
        this(pluginsFolderName, scannerType, DEFAULT_LOGGER);
    }

    public CorePluginScanner(String pluginsFolderName, ScannerType scannerType, ISimpleLogger logger) {
        this.pluginsFolder = new File(pluginsFolderName);
        this.scannerType = scannerType;
        if (!this.pluginsFolder.isDirectory()) {
            throw ConfigurationFailureException.fromTemplate("Invalid core-plugins folder '%s'", pluginsFolderName);
        }
        this.log = logger;
    }

    @Override
    public String tryLoadToString(CorePlugin plugin, String path) {
        File result = new File(this.getFolderForPlugin(plugin), path);
        if (result.isFile()) {
            return FileUtilities.loadToString(result);
        }
        return null;
    }

    public List<CorePlugin> scanForPlugins() {
        ArrayList<CorePlugin> result = new ArrayList<CorePlugin>();
        List<File> pluginDirectories = FileUtilities.listDirectories(this.pluginsFolder, false);
        Collections.sort(pluginDirectories);
        for (File pluginDir : pluginDirectories) {
            CorePlugin plugin = this.tryLoadLatestVersion(pluginDir);
            if (plugin == null) continue;
            result.add(plugin);
        }
        return result;
    }

    private CorePlugin tryLoadLatestVersion(File pluginRootDir) {
        ArrayList<CorePlugin> allVersionsForPlugin = new ArrayList<CorePlugin>();
        for (File versionDir : FileUtilities.listDirectories(pluginRootDir, false)) {
            if (this.isValidVersionDir(versionDir)) {
                CorePlugin pluginVersion = this.createPlugin(pluginRootDir, versionDir);
                File folder = this.getFolderForPlugin(pluginVersion);
                if (!folder.exists()) continue;
                allVersionsForPlugin.add(pluginVersion);
                continue;
            }
            this.log.log(LogLevel.WARN, String.format("Invalid version '%s' for plugin '%s'. Plugin version must be non-negative integer numbers.", versionDir.getName(), pluginRootDir.getAbsolutePath()));
        }
        if (allVersionsForPlugin.isEmpty()) {
            this.log.log(LogLevel.WARN, String.format("No valid versions have been detected for plugin '%s'.", pluginRootDir));
            return null;
        }
        return (CorePlugin)Collections.max(allVersionsForPlugin);
    }

    private CorePlugin createPlugin(File pluginDir, File versionDir) {
        String name = pluginDir.getName();
        int version = this.parseVersion(versionDir);
        return new CorePlugin(name, version);
    }

    private boolean isValidVersionDir(File versionDir) {
        return this.parseVersion(versionDir) >= 0;
    }

    private int parseVersion(File versionDir) {
        try {
            return Integer.parseInt(versionDir.getName());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private File getFolderForPlugin(CorePlugin plugin) {
        File unversionedFolder = new File(this.pluginsFolder, plugin.getName());
        String version = String.valueOf(plugin.getVersion());
        File versionFolder = new File(unversionedFolder, version);
        return new File(versionFolder, this.scannerType.getSubFolderName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScannerType {
        AS("as"),
        DSS("dss");

        private final String subFolderName;

        private ScannerType(String subFolderName) {
            this.subFolderName = subFolderName;
        }

        public String getSubFolderName() {
            return this.subFolderName;
        }
    }
}

