/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.common.utilities.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.dto.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.util.EqualsHashUtils;
import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIdAndCodeHolder<T extends IIdAndCodeHolder>
implements IIdAndCodeHolder,
Comparable<T>,
Serializable {
    private static final long serialVersionUID = 32L;
    public static final String CODE_PATTERN = "^[A-Z0-9_\\-\\.]+$";
    public static final String TERM_CODE_PATTERN = "^[A-Z0-9_\\-\\.:]+$";

    public static final int compare(IIdAndCodeHolder o1, IIdAndCodeHolder o2) {
        return IdAndCodeHolderComparator.INSTANCE.compare(o1, o2);
    }

    ToStringBuilder createStringBuilder() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        builder.append("code", (Object)this.getCode());
        return builder;
    }

    public boolean equals(Object obj) {
        EqualsHashUtils.assertDefined(this.getCode(), "code");
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IIdAndCodeHolder)) {
            return false;
        }
        IIdAndCodeHolder that = (IIdAndCodeHolder)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getCode(), (Object)that.getCode());
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        return builder.toHashCode();
    }

    public final String toString() {
        return this.createStringBuilder().toString();
    }

    @Override
    public final int compareTo(T o) {
        return AbstractIdAndCodeHolder.compare(this, o);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IdAndCodeHolderComparator
    implements Comparator<IIdAndCodeHolder> {
        static final Comparator<IIdAndCodeHolder> INSTANCE = new IdAndCodeHolderComparator();

        private IdAndCodeHolderComparator() {
        }

        @Override
        public final int compare(IIdAndCodeHolder o1, IIdAndCodeHolder o2) {
            String thatCode = o2.getCode();
            if (o1.getCode() == null) {
                return thatCode == null ? 0 : -1;
            }
            if (thatCode == null) {
                return 1;
            }
            return o1.getCode().compareTo(thatCode);
        }
    }
}

