/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IPermIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MappedSuperclass
public abstract class AttachmentHolderPE
implements Serializable,
IIdentifierHolder,
IPermIdHolder {
    private static final long serialVersionUID = 32L;
    public static final char HIDDEN_EXPERIMENT_PROPERTY_PREFIX_CHARACTER = '$';
    public static final String HIDDEN_EXPERIMENT_PROPERTY_PREFIX = Character.toString('$');
    public static final String HIDDEN_EXPERIMENT_PROPERTY_PREFIX2 = String.valueOf(HIDDEN_EXPERIMENT_PROPERTY_PREFIX) + HIDDEN_EXPERIMENT_PROPERTY_PREFIX;
    protected Set<AttachmentPE> attachments = new HashSet<AttachmentPE>();
    private boolean attachmentsUnescaped = false;

    @Transient
    protected abstract Set<AttachmentPE> getInternalAttachments();

    @Transient
    public abstract AttachmentHolderKind getAttachmentHolderKind();

    @Transient
    public final String getHolderName() {
        return this.getAttachmentHolderKind().name().toLowerCase();
    }

    public void setInternalAttachments(Set<AttachmentPE> attachments) {
        this.attachments = attachments;
    }

    @Transient
    public final Set<AttachmentPE> getAttachments() {
        HashSet<AttachmentPE> set = new HashSet<AttachmentPE>(this.getInternalAttachments());
        if (!this.attachmentsUnescaped) {
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                AttachmentPE property = (AttachmentPE)iter.next();
                boolean isHiddenFile = AttachmentHolderPE.isHiddenFile(property.getFileName());
                if (isHiddenFile) {
                    iter.remove();
                }
                AttachmentHolderPE.unescapeFileName(property);
            }
            this.attachmentsUnescaped = true;
        }
        return set;
    }

    final void setAttachments(Set<AttachmentPE> attachments) {
        this.getInternalAttachments().clear();
        for (AttachmentPE attachment : attachments) {
            this.addAttachment(attachment);
        }
    }

    public void addAttachment(AttachmentPE child) {
        AttachmentHolderPE parent = child.getParent();
        if (parent != null) {
            parent.getInternalAttachments().remove(child);
        }
        child.setParent(this);
        this.getInternalAttachments().add(child);
    }

    public void removeAttachment(AttachmentPE child) {
        this.getInternalAttachments().remove(child);
    }

    public static final boolean isHiddenFile(String fileName) {
        return fileName.startsWith(HIDDEN_EXPERIMENT_PROPERTY_PREFIX) && (fileName.length() == 1 || fileName.charAt(1) != '$');
    }

    public static final String escapeFileName(String fileName) {
        if (fileName != null && fileName.startsWith(HIDDEN_EXPERIMENT_PROPERTY_PREFIX)) {
            return String.valueOf(HIDDEN_EXPERIMENT_PROPERTY_PREFIX) + fileName;
        }
        return fileName;
    }

    public static final void unescapeFileName(AttachmentPE attachment) {
        String fileName;
        if (attachment != null && (fileName = attachment.getFileName()) != null && fileName.startsWith(HIDDEN_EXPERIMENT_PROPERTY_PREFIX2)) {
            attachment.setFileName(fileName.substring(1));
        }
    }

    public void ensureAttachmentsLoaded() {
        HibernateUtils.initialize(this.getInternalAttachments());
    }

    public boolean attachmentsInitialized() {
        return HibernateUtils.isInitialized(this.getInternalAttachments());
    }
}

