/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.common.utilities.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractDeletedEntityPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletedSampleRelationshipPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.util.EqualsHashUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.validator.Length;
import org.hibernate.validator.NotNull;
import org.hibernate.validator.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="samples_deleted")
public class DeletedSamplePE
extends AbstractDeletedEntityPE {
    private static final long serialVersionUID = 32L;
    private transient Long id;
    private Long containerId;
    private Long experimentId;
    private String permIdInternal;
    private SampleIdentifier sampleIdentifier;
    private SampleTypePE sampleType;
    private DatabaseInstancePE databaseInstance;
    private SpacePE space;
    private Set<DeletedSampleRelationshipPE> parentRelationships;

    @Override
    @Id
    @SequenceGenerator(name="SAMPLE_ID_SEQ", sequenceName="SAMPLE_ID_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SAMPLE_ID_SEQ")
    @DocumentId(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="expe_id", nullable=false, insertable=false, updatable=false)
    public Long getExperimentId() {
        return this.experimentId;
    }

    public void setExperimentId(Long experimentId) {
        this.experimentId = experimentId;
    }

    @Column(name="samp_id_part_of", nullable=false, insertable=false, updatable=false)
    public Long getContainerId() {
        return this.containerId;
    }

    public void setContainerId(Long containerId) {
        this.containerId = containerId;
    }

    @Override
    @Transient
    public String getPermId() {
        return this.getPermIdInternal();
    }

    @NotNull(message="Code can not be null.")
    @Length(min=1, max=60, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regex="^[A-Z0-9_\\-\\.]+$", flags=2, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    @Column(name="perm_id", nullable=false)
    private String getPermIdInternal() {
        return this.permIdInternal;
    }

    void setPermIdInternal(String permIdInternal) {
        this.permIdInternal = permIdInternal;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Sample type can not be null.")
    @JoinColumn(name="saty_id", updatable=false)
    public SampleTypePE getSampleType() {
        return this.sampleType;
    }

    public void setSampleType(SampleTypePE sampleType) {
        this.sampleType = sampleType;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="dbin_id", updatable=true)
    public DatabaseInstancePE getDatabaseInstance() {
        return this.databaseInstance;
    }

    public void setDatabaseInstance(DatabaseInstancePE databaseInstance) {
        this.databaseInstance = databaseInstance;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="space_id", updatable=false)
    public SpacePE getSpace() {
        return this.space;
    }

    public void setSpace(SpacePE space) {
        this.space = space;
    }

    @Override
    @Transient
    public EntityTypePE getEntityType() {
        return this.getSampleType();
    }

    @Override
    @Transient
    public EntityKind getEntityKind() {
        return EntityKind.SAMPLE;
    }

    @Override
    @Transient
    public String getIdentifier() {
        if (this.sampleIdentifier == null) {
            this.sampleIdentifier = IdentifierHelper.createSampleIdentifier(this);
        }
        return this.sampleIdentifier.toString();
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinColumn(name="sample_id_child")
    @Fetch(value=FetchMode.SUBSELECT)
    Set<DeletedSampleRelationshipPE> getParentRelationships() {
        return this.parentRelationships;
    }

    void setParentRelationships(Set<DeletedSampleRelationshipPE> parentRelationships) {
        this.parentRelationships = parentRelationships;
    }

    @Transient
    public List<Long> getParents() {
        if (this.parentRelationships == null || this.parentRelationships.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> parentIds = new ArrayList<Long>();
        for (DeletedSampleRelationshipPE relationship : this.parentRelationships) {
            parentIds.add(relationship.getParentId());
        }
        return parentIds;
    }

    public final boolean equals(Object obj) {
        EqualsHashUtils.assertDefined(this.getCode(), "code");
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DeletedSamplePE)) {
            return false;
        }
        DeletedSamplePE that = (DeletedSamplePE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getCode(), (Object)that.getCode());
        return builder.isEquals();
    }

    @Override
    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        return builder.toHashCode();
    }

    @Override
    public final String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        builder.append("code", (Object)this.getCode());
        builder.append("deletion", (Object)this.getDeletion());
        return builder.toString();
    }
}

