/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cascade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="material_types", uniqueConstraints={@UniqueConstraint(columnNames={"code", "dbin_id"})})
public final class MaterialTypePE
extends EntityTypePE {
    private static final long serialVersionUID = 32L;
    private Set<MaterialTypePropertyTypePE> materialTypePropertyTypes = new HashSet<MaterialTypePropertyTypePE>();

    @Override
    @SequenceGenerator(name="MATERIAL_TYPE_ID_SEQ", sequenceName="MATERIAL_TYPE_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MATERIAL_TYPE_ID_SEQ")
    public final Long getId() {
        return this.id;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="entityTypeInternal")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private Set<MaterialTypePropertyTypePE> getMaterialTypePropertyTypesInternal() {
        return this.materialTypePropertyTypes;
    }

    private void setMaterialTypePropertyTypesInternal(Set<MaterialTypePropertyTypePE> materialTypePropertyTypes) {
        this.materialTypePropertyTypes = materialTypePropertyTypes;
    }

    @Transient
    public Set<MaterialTypePropertyTypePE> getMaterialTypePropertyTypes() {
        return this.getMaterialTypePropertyTypesInternal();
    }

    public final void setMaterialTypePropertyTypes(Set<MaterialTypePropertyTypePE> materialTypePropertyTypes) {
        this.getMaterialTypePropertyTypesInternal().clear();
        for (MaterialTypePropertyTypePE child : materialTypePropertyTypes) {
            this.addMaterialTypePropertyType(child);
        }
    }

    public void addMaterialTypePropertyType(MaterialTypePropertyTypePE child) {
        MaterialTypePE parent = (MaterialTypePE)child.getEntityType();
        if (parent != null) {
            parent.getMaterialTypePropertyTypesInternal().remove(child);
        }
        child.setEntityTypeInternal(this);
        this.getMaterialTypePropertyTypesInternal().add(child);
    }

    @Override
    @Transient
    public EntityKind getEntityKind() {
        return EntityKind.MATERIAL;
    }
}

