/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.utilities.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.AuthorizationGroupPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.util.EqualsHashUtils;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.annotations.Check;
import org.hibernate.validator.NotNull;

@Entity
@Check(constraints="((DBIN_ID IS NOT NULL AND SPACE_ID IS NULL) OR (DBIN_ID IS NULL AND SPACE_ID IS NOT NULL)) AND ((AG_ID_GRANTEE IS NOT NULL AND PERS_ID_GRANTEE IS NULL) OR (AG_ID_GRANTEE IS NULL AND PERS_ID_GRANTEE IS NOT NULL))")
@Table(name="role_assignments")
public final class RoleAssignmentPE
extends HibernateAbstractRegistrationHolder
implements IIdHolder,
Serializable {
    private static final long serialVersionUID = 32L;
    public static final RoleAssignmentPE[] EMPTY_ARRAY = new RoleAssignmentPE[0];
    private transient Long id;
    private DatabaseInstancePE databaseInstance;
    private SpacePE space;
    private PersonPE person;
    private AuthorizationGroupPE authorizationGroup;
    private RoleWithHierarchy.RoleCode role;

    @NotNull(message="Role can not be null.")
    @Column(name="role_code")
    @Enumerated(value=EnumType.STRING)
    public final RoleWithHierarchy.RoleCode getRole() {
        return this.role;
    }

    public final void setRole(RoleWithHierarchy.RoleCode role) {
        this.role = role;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="pers_id_grantee", updatable=false)
    @Private
    public final PersonPE getPersonInternal() {
        return this.person;
    }

    @Private
    public final void setPersonInternal(PersonPE person) {
        this.person = person;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ag_id_grantee", updatable=false)
    @Private
    public final AuthorizationGroupPE getAuthorizationGroupInternal() {
        return this.authorizationGroup;
    }

    @Private
    public final void setAuthorizationGroupInternal(AuthorizationGroupPE authorizationGroup) {
        this.authorizationGroup = authorizationGroup;
    }

    @Transient
    public final PersonPE getPerson() {
        return this.getPersonInternal();
    }

    @Transient
    public final AuthorizationGroupPE getAuthorizationGroup() {
        return this.getAuthorizationGroupInternal();
    }

    public final void setId(Long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="space_id", updatable=false)
    public final SpacePE getSpace() {
        return this.space;
    }

    public final void setSpace(SpacePE space) {
        this.space = space;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="dbin_id", updatable=false)
    public final DatabaseInstancePE getDatabaseInstance() {
        return this.databaseInstance;
    }

    public final void setDatabaseInstance(DatabaseInstancePE databaseInstance) {
        this.databaseInstance = databaseInstance;
    }

    @SequenceGenerator(name="ROLE_ASSIGNMENT_ID_SEQ", sequenceName="ROLE_ASSIGNMENT_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ROLE_ASSIGNMENT_ID_SEQ")
    public final Long getId() {
        return this.id;
    }

    public final boolean equals(Object obj) {
        EqualsHashUtils.assertDefined(this.getRole(), "role");
        if (this.getPerson() == null) {
            EqualsHashUtils.assertDefined(this.getAuthorizationGroupInternal(), "authorization group");
        }
        if (this.getSpace() == null) {
            EqualsHashUtils.assertDefined(this.getDatabaseInstance(), "db");
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RoleAssignmentPE)) {
            return false;
        }
        RoleAssignmentPE that = (RoleAssignmentPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getRole(), (Object)that.getRole());
        builder.append((Object)this.getPerson(), (Object)that.getPerson());
        builder.append((Object)this.getAuthorizationGroup(), (Object)that.getAuthorizationGroup());
        builder.append((Object)this.getDatabaseInstance(), (Object)that.getDatabaseInstance());
        builder.append((Object)this.getSpace(), (Object)that.getSpace());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getRole());
        builder.append((Object)this.getPerson());
        builder.append((Object)this.getDatabaseInstance());
        builder.append((Object)this.getSpace());
        return builder.toHashCode();
    }

    public final String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
    }
}

